/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.midlet;

import com.sonyericsson.picasaweb.controller.ApplicationListener;
import com.sonyericsson.picasaweb.controller.MainController;
import com.sonyericsson.picasaweb.service.Database;
import com.sonyericsson.picasaweb.service.action.AddActionHandler;
import com.sonyericsson.picasaweb.service.action.CancelActionHandler;
import com.sonyericsson.picasaweb.service.action.CapabilitiesActionHandler;
import com.sonyericsson.picasaweb.service.action.DownloadActionHandler;
import com.sonyericsson.picasaweb.service.action.GetActionHandler;
import com.sonyericsson.picasaweb.service.action.InfoActionHandler;
import com.sonyericsson.picasaweb.service.action.ListActionHandler;
import com.sonyericsson.picasaweb.service.action.RemoveActionHandler;
import com.sonyericsson.picasaweb.service.action.SignInActionHandler;
import com.sonyericsson.picasaweb.service.action.SignOutActionHandler;
import com.sonyericsson.picasaweb.service.action.UpdateActionHandler;
import com.sonyericsson.picasaweb.service.action.UploadActionHandler;
import com.sonyericsson.picasaweb.service.config.Config;
import com.sonyericsson.webalbum.action.ActionHandlerMap;
import com.sonyericsson.webalbum.codec.AlbumCodec;
import com.sonyericsson.webalbum.codec.CommentCodec;
import com.sonyericsson.webalbum.codec.ContentCodec;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.codec.ImageResourceCodec;
import com.sonyericsson.webalbum.codec.ResourceCodec;
import com.sonyericsson.webalbum.invocation.InvocationHandler;
import com.sonyericsson.webalbum.job.JobManager;
import com.sonyericsson.webalbum.log.ConsoleLogWriter;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.log.LogWriter;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Registry;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class PicasaWebMidlet
extends MIDlet
implements ApplicationListener {
    private static final int DEFAULT_TIMEOUT = 100000;
    private boolean started = false;
    private MainController controller;
    private Database database;
    private JobManager jobManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        Log.info(this, "destroyApp called, unconditional = " + unconditional);
        this.controller.stop();
    }

    protected void pauseApp() {
        Log.info(this, "pauseApp called");
    }

    protected void startApp() throws MIDletStateChangeException {
        if (!this.started) {
            this.started = true;
            int logLevel = 0;
            String property = null;
            int timeout = 100000;
            Log.setWriter(this.getLogWriter());
            property = this.getAppProperty("log-level");
            if (property != null) {
                if (property.equalsIgnoreCase("none")) {
                    logLevel = 0;
                } else if (property.equalsIgnoreCase("error")) {
                    logLevel = 1;
                } else if (property.equalsIgnoreCase("warning")) {
                    logLevel = 2;
                } else if (property.equalsIgnoreCase("info")) {
                    logLevel = 3;
                } else if (property.equalsIgnoreCase("trace")) {
                    logLevel = 4;
                }
                Log.setLevel(logLevel);
                Log.trace("Log-level value set to '" + property + "'");
            }
            if ((property = this.getAppProperty("timeout")) != null) {
                timeout = Integer.parseInt(property);
                Log.trace("Timeout value set to " + timeout);
            }
            if ((property = this.getAppProperty("thumbnail-size")) != null) {
                Config.setThumbNailSize(Integer.parseInt(property));
            }
            if ((property = this.getAppProperty("photo-download-size")) != null) {
                Config.setPhotoDownloadSize(Integer.parseInt(property));
            }
            if ((property = this.getAppProperty("photo-upload-size")) != null) {
                Config.setPhotoUploadSize(Integer.parseInt(property));
            }
            if ((property = this.getAppProperty("cache-goal-size")) != null) {
                Config.setCacheGoalSize(Integer.parseInt(property));
            }
            this.database = new Database();
            this.jobManager = new JobManager();
            ContentHandlerServer server = this.getServer();
            ActionHandlerMap actionHandlerMap = this.getActionHandlerMap();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.webalbum.model.Album");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            EntryCodec.registerCodec(clazz, new AlbumCodec());
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.sonyericsson.webalbum.model.Content");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            EntryCodec.registerCodec(clazz2, new ContentCodec());
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("com.sonyericsson.webalbum.model.Comment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            EntryCodec.registerCodec(clazz3, new CommentCodec());
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("com.sonyericsson.webalbum.model.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceCodec.registerCodec(clazz4, new ResourceCodec());
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("com.sonyericsson.webalbum.model.ImageResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceCodec.registerCodec(clazz5, new ImageResourceCodec());
            InvocationHandler invocHandler = new InvocationHandler(server, timeout);
            this.controller = new MainController(this, invocHandler, actionHandlerMap);
            this.controller.start();
        }
    }

    protected ActionHandlerMap getActionHandlerMap() {
        ActionHandlerMap map = new ActionHandlerMap();
        map.addHandler("info", new InfoActionHandler(this.database));
        map.addHandler("sign-in", new SignInActionHandler(this.database));
        map.addHandler("sign-out", new SignOutActionHandler(this.database));
        map.addHandler("capabilities", new CapabilitiesActionHandler());
        map.addHandler("list", new ListActionHandler(this.database));
        map.addHandler("get", new GetActionHandler(this.database));
        map.addHandler("add", new AddActionHandler(this.database));
        map.addHandler("update", new UpdateActionHandler(this.database));
        map.addHandler("remove", new RemoveActionHandler(this.database));
        map.addHandler("upload", new UploadActionHandler(this.database, this.jobManager));
        map.addHandler("download", new DownloadActionHandler(this.database, this.jobManager));
        map.addHandler("cancel", new CancelActionHandler(this.jobManager));
        return map;
    }

    protected ContentHandlerServer getServer() {
        ContentHandlerServer server = null;
        try {
            server = Registry.getServer((String)this.getClass().getName());
        }
        catch (ContentHandlerException contentHandlerException) {
            // empty catch block
        }
        return server;
    }

    protected LogWriter getLogWriter() {
        return new ConsoleLogWriter();
    }
}

