/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service;

import com.sonyericsson.picasaweb.service.AuthUser;
import com.sonyericsson.webalbum.log.Log;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Database {
    private static final String RECORD_AUTH_TOKEN = "auth-token";
    private AuthUser authUser = null;
    private RecordStore rs;
    private int id = -1;

    public Database() {
        try {
            this.rs = RecordStore.openRecordStore((String)RECORD_AUTH_TOKEN, (boolean)true);
            RecordEnumeration re = this.rs.enumerateRecords(null, null, false);
            this.id = re.hasNextElement() ? re.nextRecordId() : this.rs.addRecord(null, 0, 0);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        Log.trace("Authorization::AuthorizationStore(): record id = " + this.id);
    }

    private String loadString() {
        String s = null;
        try {
            byte[] recordBytes = null;
            recordBytes = this.rs.getRecord(this.id);
            if (recordBytes != null) {
                s = new String(recordBytes);
            }
        }
        catch (Exception e) {
            Log.logException(e);
        }
        return s;
    }

    private boolean storeString(String s) {
        boolean success = false;
        try {
            if (s != null) {
                byte[] recordBytes = s.getBytes();
                this.rs.setRecord(this.id, recordBytes, 0, recordBytes.length);
            } else {
                this.rs.setRecord(this.id, null, 0, 0);
            }
            success = true;
        }
        catch (Exception e) {
            Log.logException(e);
        }
        return success;
    }

    public synchronized boolean setAuthUser(AuthUser authUser) {
        boolean result = false;
        String s = null;
        if (authUser != null) {
            s = authUser.toString();
        }
        if (this.storeString(s)) {
            this.authUser = authUser;
            result = true;
        }
        return result;
    }

    public synchronized AuthUser getAuthUser() {
        if (this.authUser == null) {
            this.authUser = new AuthUser(this.loadString());
        }
        return this.authUser;
    }
}

