/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.service.http.Authentication;
import com.sonyericsson.picasaweb.service.http.FeedRequest;
import com.sonyericsson.picasaweb.service.http.UrlFactory;
import com.sonyericsson.picasaweb.service.xml.AlbumParser;
import com.sonyericsson.picasaweb.service.xml.CommentParser;
import com.sonyericsson.picasaweb.service.xml.ContentParser;
import com.sonyericsson.picasaweb.service.xml.EntryParser;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.http.HttpUtil;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public abstract class ActionUtil {
    public static void doHttpRequest(HttpRequest request) throws ServiceException {
        int result;
        try {
            HttpUtil.doRequest(request);
            result = ActionUtil.resultFromHttpResponseCode(request.getResponseCode());
        }
        catch (IOException e) {
            result = 8;
        }
        if (result != 0) {
            throw new ServiceException(result);
        }
    }

    public static int resultFromHttpResponseCode(int responseCode) {
        int result = 0;
        switch (responseCode) {
            case 200: 
            case 201: {
                result = 0;
                break;
            }
            case 401: 
            case 403: {
                result = 5;
                break;
            }
            case 400: 
            case 404: {
                result = 2;
                break;
            }
            case 500: {
                result = 7;
                break;
            }
            default: {
                result = 12;
            }
        }
        return result;
    }

    public static Entry fetchEntry(String authToken, Attributes inAttr) throws ServiceException {
        String requestUrl = null;
        EntryParser entryParser = null;
        if (authToken == null) {
            throw new ServiceException(5);
        }
        String type = inAttr.get("item:type");
        if (type == null) {
            throw new ServiceException(4);
        }
        String entryId = inAttr.get(String.valueOf(type) + ":id");
        if (entryId == null) {
            throw new ServiceException(4);
        }
        if (type.equals("album")) {
            requestUrl = UrlFactory.createGetAlbumUrl(entryId);
            entryParser = new AlbumParser(0, 1, "/entry");
        } else if (type.equals("content")) {
            requestUrl = UrlFactory.createGetContentUrl(entryId);
            entryParser = new ContentParser(0, 1, "/entry", null);
        } else if (type.equals("comment")) {
            requestUrl = UrlFactory.createGetCommentUrl(entryId);
            entryParser = new CommentParser(0, 1, "/entry");
        } else {
            throw new ServiceException(3);
        }
        if (requestUrl == null || entryParser == null) {
            throw new ServiceException(12);
        }
        FeedRequest fr = new FeedRequest(requestUrl, Authentication.createHeaders(authToken), entryParser);
        ActionUtil.doHttpRequest(fr);
        Entry entry = entryParser.getFirstEntry();
        if (entry == null) {
            throw new ServiceException(12);
        }
        return entry;
    }

    private static String getFullDir(String baseDir, String dir) {
        String fullDir;
        block6: {
            fullDir = baseDir.endsWith("/") ? String.valueOf(baseDir) + dir : String.valueOf(baseDir) + "/" + dir;
            FileConnection fc = null;
            try {
                try {
                    fc = (FileConnection)Connector.open((String)fullDir);
                    if (!fc.exists()) {
                        fc.mkdir();
                    }
                }
                catch (IOException iOException) {
                    IOUtil.closeConnection((Connection)fc);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeConnection(fc);
                throw throwable;
            }
            IOUtil.closeConnection((Connection)fc);
        }
        return fullDir;
    }

    public static String getTempDir(String baseDir) {
        return ActionUtil.getFullDir(baseDir, "temp");
    }
}

