/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.service.Database;
import com.sonyericsson.picasaweb.service.action.DownloadJob;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.job.JobManager;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.DownloadItem;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.TransferItem;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.DownloadJobResponseHandler;
import com.sonyericsson.webalbum.util.CacheUtil;

public class DownloadActionHandler
implements ActionHandler {
    private Database database;
    private JobManager jobManager;

    public DownloadActionHandler(Database database, JobManager jobManager) {
        this.database = database;
        this.jobManager = jobManager;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        ActionData mainData = action.getMainData();
        Attributes mainInAttr = mainData.getAttributes();
        String authToken = this.database.getAuthUser().getAuthToken();
        try {
            int transferId = 0;
            int nrItems = action.getChildDataCount();
            int nrCompletedItems = 0;
            TransferItem[] items = new DownloadItem[nrItems];
            if (authToken == null) {
                throw new ServiceException(5);
            }
            try {
                transferId = Integer.parseInt(mainInAttr.get("transfer:id"));
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException(2);
            }
            int i = 0;
            while (i < nrItems) {
                ActionData childData = action.getChildData(i);
                String url = childData.getUrl();
                String localUrl = CacheUtil.getCachedFileUrl(url);
                Resource resource = new Resource(null);
                resource.setUrl(url);
                resource.setLocalUrl(localUrl);
                items[i] = new DownloadItem(resource);
                int fileSize = 0;
                if (CacheUtil.cachedFileIsValid(localUrl)) {
                    CacheUtil.markCachedFileAsUsed(localUrl);
                    Log.info("File is already downloaded: " + localUrl);
                    items[i].setState(5);
                    items[i].setTotalNrBytes(fileSize);
                    items[i].setCurrentNrBytes(fileSize);
                    ++nrCompletedItems;
                } else {
                    items[i].setState(1);
                }
                ++i;
            }
            DownloadJobResponseHandler downloadJobResponseHandler = new DownloadJobResponseHandler(action, responseListener);
            if (nrCompletedItems == nrItems) {
                downloadJobResponseHandler.transferCompleteNotify(transferId, items, 0);
            } else {
                if (nrCompletedItems > 0) {
                    downloadJobResponseHandler.transferProgressNotify(transferId, items);
                }
                DownloadJob dj = new DownloadJob(transferId, (DownloadItem[])items, authToken);
                dj.setTransferJobListener(downloadJobResponseHandler);
                this.jobManager.addJob(dj);
            }
        }
        catch (ServiceException se) {
            int result = se.getResult();
            Attributes outAttr = new Attributes();
            outAttr.set("result", Result.toString(result), 0);
            mainData.setAttributes(outAttr);
            responseListener.actionCompleteNotify(action);
        }
    }
}

