/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.service.AuthUser;
import com.sonyericsson.picasaweb.service.Database;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.http.Authentication;
import com.sonyericsson.picasaweb.service.http.FeedRequest;
import com.sonyericsson.picasaweb.service.http.SignInRequest;
import com.sonyericsson.picasaweb.service.http.UrlFactory;
import com.sonyericsson.picasaweb.service.xml.UserParser;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.AttributeCodec;
import com.sonyericsson.webalbum.http.HttpUtil;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.DownloadRequest;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class SignInActionHandler
implements ActionHandler {
    private static final String CAPTCHA_FILENAME = "captcha.jpg";
    private static final String ATTR_USER_NICKNAME = "user:nickname";
    private static final String ATTR_USER_NAME = "user:name";
    private static final String LOG_PREFIX = "SignInActionHandler: ";
    private static final String VALUE_CREDENTIALS_STATUS_BAD_CREDENTIALS = "bad credentials";
    private static final String VALUE_CREDENTIALS_STATUS_CAPTCHA_REQUIRED = "captcha required";
    private static final String VALUE_CREDENTIALS_STATUS_AUTHORIZED = "authorized";
    private static final String ATTR_AUTH_STATUS = "auth:status";
    private static final String ATTR_USER_LOGIN = "user:login";
    private static final String ATTR_USER_PASSWORD = "user:password";
    private static final String ATTR_CAPTCHA_ID = "captcha:id";
    private static final String ATTR_CAPTCHA_RESPONSE = "captcha:response";
    private Database database;

    public SignInActionHandler(Database database) {
        this.database = database;
    }

    private AuthUser fetchAuthUser(String authToken) throws ServiceException {
        String requestUrl = UrlFactory.createGetUserUrl();
        UserParser parser = new UserParser();
        FeedRequest fr = new FeedRequest(requestUrl, Authentication.createHeaders(authToken), parser);
        ActionUtil.doHttpRequest(fr);
        return new AuthUser(parser.getName(), parser.getNickName(), authToken);
    }

    private String fetchCaptcha(String captchaUrl, String localDirectoryUrl) throws ServiceException {
        String url = localDirectoryUrl;
        if (url == null || !url.startsWith("file://")) {
            throw new ServiceException(2);
        }
        if (captchaUrl == null) {
            throw new ServiceException(12);
        }
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        url = String.valueOf(url) + CAPTCHA_FILENAME;
        FileConnection fc = null;
        OutputStream os = null;
        DownloadRequest dr = null;
        Log.trace("SignInActionHandler: Downloading captcha from " + captchaUrl);
        try {
            try {
                fc = (FileConnection)Connector.open((String)url);
                if (!fc.exists()) {
                    fc.create();
                }
                os = fc.openOutputStream();
                dr = new DownloadRequest(captchaUrl, os);
                ActionUtil.doHttpRequest(dr);
            }
            catch (IOException e) {
                throw new ServiceException(9);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeOutputStream(os);
            IOUtil.closeConnection((Connection)fc);
            throw throwable;
        }
        IOUtil.closeOutputStream(os);
        IOUtil.closeConnection((Connection)fc);
        return url;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Attributes outAttr = new Attributes();
        try {
            String login = AttributeCodec.decodeAttribute(inAttr.get(ATTR_USER_LOGIN));
            String password = AttributeCodec.decodeAttribute(inAttr.get(ATTR_USER_PASSWORD));
            String captchaId = AttributeCodec.decodeAttribute(inAttr.get(ATTR_CAPTCHA_ID));
            String captchaResponse = AttributeCodec.decodeAttribute(inAttr.get(ATTR_CAPTCHA_RESPONSE));
            SignInRequest sir = new SignInRequest(login, password, captchaId, captchaResponse);
            try {
                HttpUtil.doRequest(sir);
                result = ActionUtil.resultFromHttpResponseCode(sir.getResponseCode());
            }
            catch (IOException e) {
                result = 8;
            }
            switch (result) {
                case 0: {
                    if (sir.getAuthStatus() == 0) {
                        AuthUser authUser = this.fetchAuthUser(sir.getAuthToken());
                        this.database.setAuthUser(authUser);
                        outAttr.set(ATTR_AUTH_STATUS, VALUE_CREDENTIALS_STATUS_AUTHORIZED);
                        outAttr.set(ATTR_USER_NAME, AttributeCodec.encodeAttribute(authUser.getName()));
                        outAttr.set(ATTR_USER_NICKNAME, AttributeCodec.encodeAttribute(authUser.getNickname()));
                        break;
                    }
                    result = 12;
                    break;
                }
                case 5: {
                    if (sir.getAuthStatus() == 3) {
                        String url = actionData.getUrl();
                        outAttr.set(ATTR_AUTH_STATUS, VALUE_CREDENTIALS_STATUS_CAPTCHA_REQUIRED);
                        outAttr.set(ATTR_USER_LOGIN, login);
                        outAttr.set(ATTR_USER_PASSWORD, password);
                        outAttr.set(ATTR_CAPTCHA_ID, AttributeCodec.encodeAttribute(sir.getCaptchaToken()));
                        url = this.fetchCaptcha(sir.getCaptchaURL(), url);
                        actionData.setUrl(url);
                        Log.trace("SignInActionHandler: Captcha downloaded to " + url);
                        result = 0;
                        break;
                    }
                    if (sir.getAuthStatus() == 1) {
                        outAttr.set(ATTR_AUTH_STATUS, VALUE_CREDENTIALS_STATUS_BAD_CREDENTIALS);
                        outAttr.set(ATTR_USER_LOGIN, login);
                        result = 0;
                        break;
                    }
                    result = 12;
                }
            }
        }
        catch (ServiceException se) {
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

