/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.xml;

import com.sonyericsson.picasaweb.service.util.EntryUtil;
import com.sonyericsson.picasaweb.service.xml.EntryParser;
import com.sonyericsson.webalbum.model.Album;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.ImageResource;
import com.sonyericsson.webalbum.util.MimeUtil;
import org.xml.sax.Attributes;

public class AlbumParser
extends EntryParser {
    public AlbumParser(int startIndex, int endIndex, String entryPath) {
        super(startIndex, endIndex, entryPath);
    }

    public void startElement(String element, Attributes attributes) {
        super.startElement(element, attributes);
        if (this.currentEntry != null && this.isCurrentPath(String.valueOf(this.entryPath) + "/media:group/media:thumbnail")) {
            String url = attributes.getValue("url");
            String width = attributes.getValue("width");
            String height = attributes.getValue("height");
            ImageResource resource = new ImageResource("cover-image", url, MimeUtil.getContentTypeFromUrl(url), Integer.parseInt(width), Integer.parseInt(height));
            this.currentEntry.addResource(resource);
        }
    }

    public void characters(String element, char[] ch, int start, int length) {
        super.characters(element, ch, start, length);
        if (this.currentEntry != null) {
            if (this.isCurrentPath(String.valueOf(this.entryPath) + "/title")) {
                ((Album)this.currentEntry).setTitle(new String(ch, start, length));
            } else if (this.isCurrentPath(String.valueOf(this.entryPath) + "/summary")) {
                ((Album)this.currentEntry).setDescription(new String(ch, start, length));
            } else if (this.isCurrentPath(String.valueOf(this.entryPath) + "/rights")) {
                String picasaAccess = new String(ch, start, length);
                String access = "public".equals(picasaAccess) ? "public" : ("protected".equals(picasaAccess) ? "contacts" : "private");
                ((Album)this.currentEntry).setAccess(access);
            }
        }
    }

    protected Entry createEntry() {
        return new Album();
    }

    protected String getEntryId(String urlPart) {
        return EntryUtil.encodeAlbumId(urlPart);
    }
}

