/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.codec;

import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.AttributeCodec;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Entry;

public class ContentCodec
extends EntryCodec {
    public static final String ITEM_TYPE = "content";
    public static final String ATTR_TITLE = ":title";
    public static final String ATTR_DESCRIPTION = ":description";
    public static final String ATTR_TEXT = ":text";
    public static final String ATTR_ACCESS = ":access";
    public static final String ATTR_MEDIUM = ":medium";

    public ContentCodec() {
        super(ITEM_TYPE);
    }

    protected Entry createEntry() {
        return new Content();
    }

    protected void encodeEntry(Entry entry, Attributes attr) {
        super.encodeEntry(entry, attr);
        Content content = (Content)entry;
        Log.trace("ContentCodec.encodeEntry()");
        attr.set("content:title", AttributeCodec.encodeAttribute(content.getTitle()));
        attr.set("content:description", AttributeCodec.encodeAttribute(content.getDescription()));
        attr.set("content:text", AttributeCodec.encodeAttribute(content.getText()));
        attr.set("content:medium", AttributeCodec.encodeAttribute(content.getMedium()));
        attr.set("content:access", AttributeCodec.encodeAttribute(content.getAccess()));
        attr.set("album:id", content.getAlbumId());
        this.encodeResource(entry, ITEM_TYPE, attr);
        this.encodeResource(entry, "thumbnail", attr);
    }

    protected void decodeEntry(Attributes attr, Entry entry) {
        super.decodeEntry(attr, entry);
        Content content = (Content)entry;
        Log.trace("ContentCodec.decodeEntry()");
        content.setTitle(AttributeCodec.decodeAttribute(attr.get("content:title")));
        content.setDescription(AttributeCodec.decodeAttribute(attr.get("content:description")));
        content.setText(AttributeCodec.decodeAttribute(attr.get("content:text")));
        content.setMedium(AttributeCodec.decodeAttribute(attr.get("content:medium")));
        content.setAccess(AttributeCodec.decodeAttribute(attr.get("content:access")));
        content.setAlbumId(attr.get("album:id"));
    }
}

