/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.service.http.AddAlbumRequest;
import com.sonyericsson.facebook.service.http.AddCommentRequest;
import com.sonyericsson.facebook.service.http.FacebookErrors;
import com.sonyericsson.facebook.service.http.FacebookHttpUtil;
import com.sonyericsson.facebook.service.xml.AddAlbumParser;
import com.sonyericsson.facebook.service.xml.AddCommentParser;
import com.sonyericsson.facebook.utils.RMSAuth;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;

public class AddActionHandler
implements ActionHandler {
    private RMSAuth rmsAuth;

    public void handleAction(Action action, ActionResponseListener responseListener) {
        block5: {
            int result = 12;
            Attributes outAttr = new Attributes();
            ActionData actionData = action.getMainData();
            Attributes inAttr = actionData.getAttributes();
            String type = inAttr.get("item:type");
            outAttr.set("item:type", type);
            try {
                this.rmsAuth = RMSAuth.getRMSAuth();
                if (type == null) {
                    throw new ServiceException(4);
                }
                if (type.equalsIgnoreCase("album")) {
                    this.handleAddAlbumRequest(action);
                    break block5;
                }
                if (type.equalsIgnoreCase("comment")) {
                    this.handleAddCommentRequest(action);
                    break block5;
                }
                throw new ServiceException(3);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing Add Action Handler: " + se.getMessage());
                result = se.getResult();
                outAttr.set("result", Result.toString(result), 0);
                actionData.setAttributes(outAttr);
            }
        }
        responseListener.actionCompleteNotify(action);
    }

    private void handleAddAlbumRequest(Action addAlbumAction) {
        int result = 12;
        String errorCode = "";
        Attributes outAttr = new Attributes();
        ActionData addAlbumActionData = addAlbumAction.getMainData();
        Attributes inAttr = addAlbumActionData.getAttributes();
        String albumTitle = inAttr.get("album:title");
        String albumDescription = inAttr.get("album:description");
        String albumLocation = inAttr.get("album:location");
        try {
            if (albumTitle == null) {
                throw new ServiceException(4);
            }
            if (albumTitle.trim().length() == 0) {
                throw new ServiceException(2);
            }
            String sessionKey = this.rmsAuth.getSessionKey();
            String secret = this.rmsAuth.getSecret();
            if (sessionKey == null || secret == null || sessionKey.trim().length() <= 0 || secret.trim().length() <= 0) {
                throw new ServiceException(5);
            }
            AddAlbumParser addAlbumParser = new AddAlbumParser();
            AddAlbumRequest addAlbumRequest = new AddAlbumRequest(addAlbumParser, sessionKey, secret, albumTitle, albumDescription, albumLocation);
            result = FacebookHttpUtil.doRequest(addAlbumRequest);
            errorCode = addAlbumParser.getErrorCode();
            if (result == 0 && !errorCode.trim().equalsIgnoreCase("")) {
                result = FacebookErrors.getWebAlbumErrorCode(errorCode);
            } else if (result == 0) {
                outAttr.set("album:id", addAlbumParser.getAid(), 2);
                outAttr.set("album:title", addAlbumParser.getTitle(), 3);
                outAttr.set("album:description", addAlbumParser.getDescription(), 4);
                outAttr.set("album:access", addAlbumParser.getAccess(), 5);
                outAttr.set("album:timestamp", addAlbumParser.getTimestamp(), 6);
                outAttr.set("album:webpage-url", addAlbumParser.getLink(), 7);
            }
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing Add Album Action Handler: " + se.getMessage());
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        addAlbumActionData.setAttributes(outAttr);
    }

    private void handleAddCommentRequest(Action addCommentAction) {
        int result = 12;
        String errorCode = "";
        Attributes outAttr = new Attributes();
        ActionData addCommentActionData = addCommentAction.getMainData();
        Attributes inAttr = addCommentActionData.getAttributes();
        String photoId = inAttr.get("content:id");
        String commentText = inAttr.get("comment:text");
        try {
            if (photoId == null || commentText == null) {
                throw new ServiceException(4);
            }
            if (photoId.trim().length() == 0 || commentText.trim().length() == 0) {
                throw new ServiceException(2);
            }
            String sessionKey = this.rmsAuth.getSessionKey();
            String secret = this.rmsAuth.getSecret();
            if (sessionKey == null || secret == null || sessionKey.trim().length() <= 0 || secret.trim().length() <= 0) {
                throw new ServiceException(5);
            }
            AddCommentParser addCommentParser = new AddCommentParser();
            AddCommentRequest addCommentRequest = new AddCommentRequest(addCommentParser, sessionKey, secret, photoId, commentText);
            result = FacebookHttpUtil.doRequest(addCommentRequest);
            errorCode = addCommentParser.getErrorCode();
            if (result == 0 && !errorCode.trim().equalsIgnoreCase("")) {
                result = FacebookErrors.getWebAlbumErrorCode(errorCode);
            }
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing Add Comment Action Handler: " + se.getMessage());
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        addCommentActionData.setAttributes(outAttr);
    }
}

