/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.job.JobManager;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;

public class CancelActionHandler
implements ActionHandler {
    private JobManager jobManager;

    public CancelActionHandler(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Attributes outAttr = new Attributes();
        String transferIdString = null;
        int transferId = -1;
        try {
            transferIdString = inAttr.get("transfer:id");
            if (transferIdString == null) {
                throw new ServiceException(4);
            }
            if (transferIdString.trim().length() == 0) {
                throw new ServiceException(2);
            }
            try {
                transferId = Integer.parseInt(transferIdString);
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException(2);
            }
            if (!this.jobManager.cancelJob(transferId)) {
                Log.error("Transfer job cancellation failed.");
                throw new ServiceException(2);
            }
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing Cancel Action Handler: " + se.getMessage());
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

