/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.service.action.DownloadJob;
import com.sonyericsson.facebook.service.action.DownloadJobResponseHandler;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.job.JobManager;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.DownloadItem;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.TransferItem;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.CacheUtil;
import com.sonyericsson.webalbum.util.IOUtil;

public class DownloadActionHandler
implements ActionHandler {
    private JobManager jobManager;

    public DownloadActionHandler(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        ActionData mainData = action.getMainData();
        Attributes mainInAttr = mainData.getAttributes();
        ActionData childData = null;
        String downloadUrl = null;
        String localUrl = null;
        int transferId = 0;
        int nrItems = action.getChildDataCount();
        TransferItem[] items = new DownloadItem[nrItems];
        int nrCompletedItems = 0;
        try {
            try {
                transferId = Integer.parseInt(mainInAttr.get("transfer:id"));
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException(2);
            }
            int i = 0;
            while (i < nrItems) {
                childData = action.getChildData(i);
                downloadUrl = childData.getUrl();
                localUrl = CacheUtil.getCachedFileUrl(downloadUrl);
                Resource resource = new Resource(null);
                resource.setUrl(downloadUrl);
                resource.setLocalUrl(localUrl);
                items[i] = new DownloadItem(resource);
                int fileSize = 0;
                if (CacheUtil.cachedFileIsValid(localUrl)) {
                    CacheUtil.markCachedFileAsUsed(localUrl);
                    Log.info(this, "File is already downloaded: " + localUrl);
                    items[i].setState(5);
                    fileSize = IOUtil.getFileSize(localUrl);
                    items[i].setTotalNrBytes(fileSize);
                    items[i].setCurrentNrBytes(fileSize);
                    ++nrCompletedItems;
                } else {
                    items[i].setState(1);
                }
                ++i;
            }
            DownloadJobResponseHandler dlJobResponseHandler = new DownloadJobResponseHandler(action, responseListener);
            if (nrCompletedItems == nrItems) {
                dlJobResponseHandler.transferCompleteNotify(transferId, items, 0);
            } else {
                if (nrCompletedItems > 0) {
                    dlJobResponseHandler.transferProgressNotify(transferId, items);
                }
                DownloadJob dj = new DownloadJob(transferId, (DownloadItem[])items);
                dj.setTransferJobListener(dlJobResponseHandler);
                this.jobManager.addJob(dj);
                Log.trace(this, "Download job queued.");
            }
        }
        catch (ServiceException se) {
            int result = se.getResult();
            Attributes outAttr = new Attributes();
            outAttr.set("result", Result.toString(result), 0);
            mainData.setAttributes(outAttr);
            responseListener.actionCompleteNotify(action);
        }
    }
}

