/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.service.http.FacebookHttpUtil;
import com.sonyericsson.webalbum.http.HttpUtil;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.DownloadItem;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.TransferItem;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.DownloadRequest;
import com.sonyericsson.webalbum.service.transfer.TransferJob;
import com.sonyericsson.webalbum.service.transfer.TransferRequestProgressListener;
import com.sonyericsson.webalbum.util.CacheUtil;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.file.FileConnection;

public class DownloadJob
extends TransferJob
implements TransferRequestProgressListener {
    private static final int DOWNLOAD_PROGRESS_INTERVAL = 10240;

    public DownloadJob(int id, DownloadItem[] items) {
        super(id, items);
    }

    protected int transferCurrentItem() {
        DownloadItem item = (DownloadItem)this.getCurrentItem();
        Resource resource = item.getResource();
        String url = resource.getUrl();
        String localUrl = resource.getLocalUrl();
        item.setState(2);
        this.reportProgress();
        return this.downloadFile(url, localUrl);
    }

    public void requestProgressNotify() {
        TransferItem item = this.getCurrentItem();
        item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
        item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
        this.reportProgress();
    }

    private int downloadFile(String url, String localUrl) {
        int result;
        block20: {
            result = 12;
            DownloadItem item = (DownloadItem)this.getCurrentItem();
            FileConnection fc = null;
            OutputStream os = null;
            Log.trace(this, "Downloading from " + url + " to " + localUrl);
            try {
                fc = CacheUtil.createCachedFile(localUrl);
                os = fc.openOutputStream();
                this.currentRequest = new DownloadRequest(url, null, os);
                this.currentRequest.setTransferRequestProgressListener(this, 10240);
                try {
                    if (this.cancelled) {
                        this.currentRequest.cancel();
                    } else {
                        Log.trace(this, "Making download request");
                        HttpUtil.doRequest(this.currentRequest);
                        Log.trace(this, "Request complete");
                        result = FacebookHttpUtil.resultFromHttpResponseCode(this.currentRequest.getResponseCode());
                    }
                }
                catch (IOException e) {
                    Log.error("IO Exception on trying to download file. Error: " + e.getMessage());
                    result = 8;
                }
                if (result != 0) {
                    throw new ServiceException(result);
                }
                if (!this.currentRequest.isCancelled()) {
                    Log.trace(this, "Marking cached file as valid");
                    CacheUtil.markCachedFileAsValid(localUrl);
                    item.setState(5);
                }
            }
            catch (IOException e) {
                result = 9;
                Log.error("Error handling local Cache file");
                item.setState(4);
                Log.logException(e);
                IOUtil.closeOutputStream(os);
                IOUtil.closeConnection((Connection)fc);
                if (this.currentRequest != null) {
                    item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
                    item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                    if (this.currentRequest.isCancelled()) {
                        item.setState(3);
                        result = 1;
                    }
                    this.currentRequest = null;
                }
                break block20;
            }
            catch (ServiceException e) {
                try {
                    item.setState(4);
                    Log.logException(e);
                    result = e.getResult();
                }
                catch (Throwable throwable) {
                    IOUtil.closeOutputStream(os);
                    IOUtil.closeConnection((Connection)fc);
                    if (this.currentRequest != null) {
                        item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
                        item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                        if (this.currentRequest.isCancelled()) {
                            item.setState(3);
                            result = 1;
                        }
                        this.currentRequest = null;
                    }
                    throw throwable;
                }
                IOUtil.closeOutputStream(os);
                IOUtil.closeConnection((Connection)fc);
                if (this.currentRequest != null) {
                    item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
                    item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                    if (this.currentRequest.isCancelled()) {
                        item.setState(3);
                        result = 1;
                    }
                    this.currentRequest = null;
                }
                break block20;
            }
            IOUtil.closeOutputStream(os);
            IOUtil.closeConnection((Connection)fc);
            if (this.currentRequest != null) {
                item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
                item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                if (this.currentRequest.isCancelled()) {
                    item.setState(3);
                    result = 1;
                }
                this.currentRequest = null;
            }
        }
        return result;
    }
}

