/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.model.FacebookAlbum;
import com.sonyericsson.facebook.model.FacebookContent;
import com.sonyericsson.facebook.service.http.FacebookErrors;
import com.sonyericsson.facebook.service.http.FacebookHttpUtil;
import com.sonyericsson.facebook.service.http.ListAlbumRequest;
import com.sonyericsson.facebook.service.http.ListContentRequest;
import com.sonyericsson.facebook.service.utils.ServiceUtils;
import com.sonyericsson.facebook.service.xml.ListAlbumParser;
import com.sonyericsson.facebook.service.xml.ListContentParser;
import com.sonyericsson.facebook.utils.RMSAuth;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.EntryList;
import com.sonyericsson.webalbum.model.ImageResource;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.MimeUtil;

public class GetActionHandler
implements ActionHandler {
    private RMSAuth rmsAuth;

    public void handleAction(Action action, ActionResponseListener responseListener) {
        block5: {
            int result = 12;
            ActionData actionData = action.getMainData();
            Attributes inAttr = actionData.getAttributes();
            String type = inAttr.get("item:type");
            Attributes outAttr = new Attributes();
            try {
                this.rmsAuth = RMSAuth.getRMSAuth();
                if (type == null) {
                    throw new ServiceException(4);
                }
                if (type.equalsIgnoreCase("album")) {
                    this.handleGetAlbumRequest(action);
                    break block5;
                }
                if (type.equalsIgnoreCase("content")) {
                    this.handleGetContentRequest(action);
                    break block5;
                }
                throw new ServiceException(3);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing Get Action Handler: " + se.getMessage());
                result = se.getResult();
                outAttr.set("result", Result.toString(result), 0);
                actionData.setAttributes(outAttr);
            }
        }
        responseListener.actionCompleteNotify(action);
    }

    private void handleGetContentRequest(Action getContentAction) {
        ActionData getContentActionData;
        Attributes outAttr;
        int result;
        block10: {
            result = 12;
            outAttr = new Attributes();
            EntryList contentList = null;
            getContentActionData = getContentAction.getMainData();
            Attributes inAttr = getContentActionData.getAttributes();
            String contentId = inAttr.get("content:id");
            String isRefreshForced = inAttr.get("get:force-refresh");
            String sessionKey = this.rmsAuth.getSessionKey();
            String secret = this.rmsAuth.getSecret();
            try {
                if (sessionKey == null || sessionKey.trim().length() <= 0 || secret == null || secret.trim().length() <= 0) {
                    Log.error("Invalid autorization parameters");
                    throw new ServiceException(5);
                }
                if (contentId == null) {
                    Log.error("contentId is missing");
                    throw new ServiceException(4);
                }
                if (contentId.trim().length() <= 0) {
                    Log.error("contentId is invalid");
                    throw new ServiceException(2);
                }
                ListContentParser listContentParser = new ListContentParser();
                ListContentRequest getContentReq = new ListContentRequest(listContentParser, sessionKey, secret, null, contentId);
                result = FacebookHttpUtil.doRequest(getContentReq, isRefreshForced.equalsIgnoreCase("true"));
                contentList = listContentParser.getEntries();
                String errorCode = listContentParser.getErrorCode();
                if (result == 0 && !errorCode.trim().equalsIgnoreCase("")) {
                    result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                    break block10;
                }
                if (result != 0) break block10;
                if (contentList != null) {
                    Log.trace(this, "Getting parsed entries.");
                    Entry entry = contentList.getEntry(0);
                    if (entry != null) {
                        FacebookContent contentEntry = (FacebookContent)entry;
                        ImageResource image = null;
                        String imageUrl = contentEntry.getSrcBig();
                        if (imageUrl != null && imageUrl.length() > 0) {
                            image = new ImageResource("content", imageUrl, MimeUtil.getContentTypeFromUrl(imageUrl), 604, 604);
                            contentEntry.addResource(image);
                        }
                        ImageResource thumbImg = null;
                        String thumbUrl = contentEntry.getSrcSmall();
                        if (thumbUrl != null && thumbUrl.length() > 0) {
                            thumbImg = new ImageResource("thumbnail", thumbUrl, MimeUtil.getContentTypeFromUrl(thumbUrl), 75, 75);
                            contentEntry.addResource(thumbImg);
                        }
                        outAttr = EntryCodec.encodeEntry(contentEntry);
                        break block10;
                    }
                    Log.trace(this, "Returned null content entry.");
                    throw new ServiceException(9);
                }
                Log.trace(this, "Returned null content list.");
                throw new ServiceException(9);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing Get Action Handler: " + se.getMessage());
                result = se.getResult();
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        getContentActionData.setAttributes(outAttr);
    }

    private void handleGetAlbumRequest(Action getAlbumAction) {
        ActionData getAlbumActionData;
        Attributes outAttr;
        int result;
        block10: {
            result = 12;
            outAttr = new Attributes();
            EntryList album = null;
            getAlbumActionData = getAlbumAction.getMainData();
            Attributes inAttr = getAlbumActionData.getAttributes();
            String aids = inAttr.get("album:id");
            String isRefreshForced = inAttr.get("get:force-refresh");
            String sessionKey = this.rmsAuth.getSessionKey();
            String secret = this.rmsAuth.getSecret();
            try {
                if (sessionKey == null || sessionKey.trim().length() <= 0 || secret == null || secret.trim().length() <= 0) {
                    Log.error("Invalid autorization parameters");
                    throw new ServiceException(5);
                }
                if (aids == null) {
                    Log.error("Aids is missing");
                    throw new ServiceException(4);
                }
                if (aids.trim().length() <= 0) {
                    Log.error("Aids is invalid");
                    throw new ServiceException(2);
                }
                ListAlbumParser getAlbumParser = new ListAlbumParser();
                ListAlbumRequest getAlbumReq = new ListAlbumRequest(getAlbumParser, sessionKey, secret, aids);
                result = FacebookHttpUtil.doRequest(getAlbumReq, isRefreshForced.equalsIgnoreCase("true"));
                album = getAlbumParser.getEntries();
                String errorCode = getAlbumParser.getErrorCode();
                if (result == 0 && !errorCode.trim().equalsIgnoreCase("")) {
                    result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                    break block10;
                }
                if (result != 0) break block10;
                if (album != null) {
                    FacebookAlbum albumEntry;
                    Log.trace(this, "Getting parsed entries.");
                    Entry entry = album.getEntry(0);
                    if (entry != null) {
                        albumEntry = (FacebookAlbum)entry;
                        if (ServiceUtils.isProfilePictures(albumEntry)) {
                            albumEntry.setTitle(ServiceUtils.mapProfilePictureTitle(this.rmsAuth.getLocale()));
                        }
                    } else {
                        Log.trace(this, "Returned null album entry.");
                        throw new ServiceException(9);
                    }
                    outAttr = EntryCodec.encodeEntry(albumEntry);
                    Log.trace(this, "Ended parsing album entry with result: " + result + ".");
                    break block10;
                }
                Log.trace(this, "Returned null album list.");
                throw new ServiceException(9);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing Get Action Handler: " + se.getMessage());
                result = se.getResult();
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        getAlbumActionData.setAttributes(outAttr);
    }
}

