/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.utils.RMSAuth;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class InfoActionHandler
implements ActionHandler {
    private static final String ATTR_USER_NAME = "user:name";
    private static final String ATTR_USER_NICKNAME = "user:nickname";
    private static final String ATTR_AUTH_SIGN_UP_URL = "auth:sign-up-url";
    private static final String ATTR_AUTH_ENABLED = "auth:enabled";
    private static final String ATTR_VIDEO_MAX_SIZE = "video:max-size";
    private static final String ATTR_VIDEO_MAX_LENGTH = "video:max-length";
    private static final String LOG_PREFIX = "InfoActionHandler: ";
    private static final String FACEBOOK_SIGN_UP_URL = "http://www.facebook.com/r.php";
    private RMSAuth rmsAuth;

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes outAttr = new Attributes();
        String baseDir = actionData.getUrl();
        String userName = null;
        String userNickname = null;
        String sessionKey = null;
        try {
            this.rmsAuth = RMSAuth.getRMSAuth();
            if (baseDir != null && baseDir.startsWith("file://")) {
                String iconUrl = this.copyIcon(baseDir);
                actionData.setUrl(iconUrl);
            }
            outAttr.set("result", Result.toString(result), 0);
            outAttr.set(ATTR_AUTH_ENABLED, "true");
            outAttr.set(ATTR_AUTH_SIGN_UP_URL, FACEBOOK_SIGN_UP_URL);
            outAttr.set(ATTR_VIDEO_MAX_SIZE, "104857600");
            outAttr.set(ATTR_VIDEO_MAX_LENGTH, "120");
            sessionKey = this.rmsAuth.getSessionKey();
            if (sessionKey != null && sessionKey.length() > 0) {
                userName = this.rmsAuth.getName();
                if (userName != null && userName.length() > 0) {
                    outAttr.set(ATTR_USER_NAME, userName);
                }
                if ((userNickname = this.rmsAuth.getNick()) != null && userNickname.length() > 0) {
                    outAttr.set(ATTR_USER_NICKNAME, userNickname);
                }
            }
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing Info Action Handler: " + se.getMessage());
            result = se.getResult();
            outAttr.set("result", Result.toString(result), 0);
        }
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }

    private String copyIcon(String baseDir) throws ServiceException {
        String url = baseDir;
        FileConnection fconn = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        url = String.valueOf(url) + "facebook_large.png";
        Log.trace("InfoActionHandler: copying icon to " + url);
        try {
            try {
                fconn = (FileConnection)Connector.open((String)url);
                if (!fconn.exists()) {
                    Log.trace("InfoActionHandler: creating icon file");
                    fconn.create();
                }
                Log.trace("InfoActionHandler: opening streams");
                outputStream = fconn.openOutputStream();
                Log.trace("InfoActionHandler: created os " + outputStream);
                inputStream = this.getClass().getResourceAsStream("/facebook_large.png");
                Log.trace("InfoActionHandler: created is " + inputStream);
                int nrBytes = IOUtil.copyStream(inputStream, outputStream);
                Log.trace("InfoActionHandler: data written: " + nrBytes + " bytes");
            }
            catch (IOException e) {
                Log.error("Exception was caught when trying to copy the plug-in icon");
                throw new ServiceException(9);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeInputStream(inputStream);
            IOUtil.closeOutputStream(outputStream);
            IOUtil.closeConnection((Connection)fconn);
            throw throwable;
        }
        IOUtil.closeInputStream(inputStream);
        IOUtil.closeOutputStream(outputStream);
        IOUtil.closeConnection((Connection)fconn);
        return url;
    }
}

