/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.model.FacebookAlbum;
import com.sonyericsson.facebook.model.FacebookComment;
import com.sonyericsson.facebook.model.FacebookContent;
import com.sonyericsson.facebook.service.http.FacebookErrors;
import com.sonyericsson.facebook.service.http.FacebookHttpUtil;
import com.sonyericsson.facebook.service.http.ListAlbumRequest;
import com.sonyericsson.facebook.service.http.ListCommentRequest;
import com.sonyericsson.facebook.service.http.ListContentRequest;
import com.sonyericsson.facebook.service.http.UserInfoRequest;
import com.sonyericsson.facebook.service.utils.ServiceUtils;
import com.sonyericsson.facebook.service.xml.ListAlbumParser;
import com.sonyericsson.facebook.service.xml.ListCommentParser;
import com.sonyericsson.facebook.service.xml.ListContentParser;
import com.sonyericsson.facebook.service.xml.UserInfoParser;
import com.sonyericsson.facebook.utils.RMSAuth;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.EntryList;
import com.sonyericsson.webalbum.model.ImageResource;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.MimeUtil;
import java.util.Vector;

public class ListActionHandler
implements ActionHandler {
    private RMSAuth rmsAuth;

    public void handleAction(Action action, ActionResponseListener responseListener) {
        block6: {
            int result = 12;
            ActionData actionData = action.getMainData();
            Attributes inAttr = actionData.getAttributes();
            String type = inAttr.get("item:type");
            Attributes outAttr = new Attributes();
            outAttr.set("item:type", type);
            try {
                this.rmsAuth = RMSAuth.getRMSAuth();
                if (type == null) {
                    throw new ServiceException(4);
                }
                if (type.equalsIgnoreCase("album")) {
                    this.handleListAlbumRequest(action);
                    break block6;
                }
                if (type.equalsIgnoreCase("content")) {
                    this.handleListContentRequest(action);
                    break block6;
                }
                if (type.equalsIgnoreCase("comment")) {
                    this.handleListCommentRequest(action);
                    break block6;
                }
                throw new ServiceException(3);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing List action handler: " + se.getMessage());
                result = se.getResult();
                outAttr.set("result", Result.toString(result), 0);
                actionData.setAttributes(outAttr);
            }
        }
        responseListener.actionCompleteNotify(action);
    }

    private void handleListAlbumRequest(Action listAlbumAction) {
        ActionData listAlbumActionData;
        Attributes outAttr;
        int result;
        block14: {
            result = 12;
            int listContentResult = 12;
            EntryList albumList = null;
            outAttr = new Attributes();
            Attributes partOutAttr = null;
            int startIndex = 0;
            int endIndex = Integer.MAX_VALUE;
            listAlbumActionData = listAlbumAction.getMainData();
            Attributes inAttr = listAlbumActionData.getAttributes();
            String isRefreshForced = inAttr.get("list:force-refresh");
            String startIndexStr = inAttr.get("list:start-entry");
            String endIndexStr = inAttr.get("list:end-entry");
            String sessionKey = this.rmsAuth.getSessionKey();
            String secret = this.rmsAuth.getSecret();
            try {
                if (sessionKey == null || sessionKey.trim().length() <= 0 || secret == null || secret.trim().length() <= 0) {
                    Log.error("Invalid autorization parameters");
                    throw new ServiceException(5);
                }
                if (startIndexStr != null && endIndexStr != null) {
                    try {
                        startIndex = Integer.parseInt(startIndexStr);
                        endIndex = Integer.parseInt(endIndexStr);
                    }
                    catch (NumberFormatException nfEx) {
                        Log.error("Error trying to parse startIndex and EndIndex: " + nfEx.getMessage());
                        throw new ServiceException(2);
                    }
                }
                if (endIndex <= startIndex) {
                    throw new ServiceException(2);
                }
                ListAlbumParser listAlbumParser = new ListAlbumParser();
                ListAlbumRequest listAlbumReq = new ListAlbumRequest(listAlbumParser, sessionKey, secret, null);
                result = FacebookHttpUtil.doRequest(listAlbumReq, isRefreshForced.equalsIgnoreCase("true"));
                albumList = listAlbumParser.getEntries();
                String errorCode = listAlbumParser.getErrorCode();
                if (result == 0 && !errorCode.trim().equalsIgnoreCase("")) {
                    result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                    break block14;
                }
                if (result != 0) break block14;
                Vector pidsVector = listAlbumParser.getPidsVector();
                ListContentParser listContentParser = new ListContentParser();
                if (this.isValidPidsVector(pidsVector)) {
                    String pidList = "";
                    int i = 0;
                    while (i < pidsVector.size()) {
                        pidList = pidList.concat(pidsVector.elementAt(i) + ",");
                        ++i;
                    }
                    ListContentRequest listContentReq = new ListContentRequest(listContentParser, sessionKey, secret, null, pidList);
                    listContentResult = FacebookHttpUtil.doRequest(listContentReq, isRefreshForced.equalsIgnoreCase("true"));
                    String listContenterrorCode = listContentParser.getErrorCode();
                    if (listContentResult == 0 && !listContenterrorCode.trim().equalsIgnoreCase("")) {
                        listContentResult = FacebookErrors.getWebAlbumErrorCode(listContenterrorCode);
                        throw new ServiceException(listContentResult);
                    }
                }
                if (albumList != null) {
                    ActionData childData = null;
                    Log.trace(this, "Getting parsed entries.");
                    int i = startIndex;
                    while (i < endIndex) {
                        Entry entry = albumList.getEntry(i);
                        if (entry == null) {
                            Log.trace(this, "Returned null album. Ending album list filling loop.");
                            endIndex = i;
                            break;
                        }
                        FacebookAlbum albumEntry = null;
                        albumEntry = this.getAlbumCoverImage(entry, listContentParser);
                        childData = listAlbumAction.addChildData();
                        partOutAttr = EntryCodec.encodeEntry(albumEntry);
                        childData.setAttributes(partOutAttr);
                        ++i;
                    }
                    Log.trace(this, "Ended parsing album entries with result " + result + ".");
                    outAttr.set("list:entry-count", String.valueOf(albumList.getTotalNrOfEntries()));
                    outAttr.set("list:start-entry", String.valueOf(startIndex));
                    outAttr.set("list:end-entry", String.valueOf(endIndex));
                    break block14;
                }
                throw new ServiceException(12);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing List Action Handler: " + se.getMessage());
                result = se.getResult();
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        listAlbumActionData.setAttributes(outAttr);
    }

    private void handleListContentRequest(Action listContentAction) {
        ActionData listContentActionData;
        Attributes outAttr;
        int result;
        block10: {
            result = 12;
            EntryList contentList = null;
            outAttr = new Attributes();
            Attributes partOutAttr = null;
            int startIndex = 0;
            int endIndex = Integer.MAX_VALUE;
            listContentActionData = listContentAction.getMainData();
            Attributes inAttr = listContentActionData.getAttributes();
            String aid = inAttr.get("album:id");
            String isRefreshForced = inAttr.get("list:force-refresh");
            String startIndexStr = inAttr.get("list:start-entry");
            String endIndexStr = inAttr.get("list:end-entry");
            String sessionKey = this.rmsAuth.getSessionKey();
            String secret = this.rmsAuth.getSecret();
            try {
                this.checkParameters(sessionKey, secret, aid);
                if (startIndexStr != null && endIndexStr != null) {
                    try {
                        startIndex = Integer.parseInt(startIndexStr);
                        endIndex = Integer.parseInt(endIndexStr);
                    }
                    catch (NumberFormatException nfEx) {
                        Log.error("Error trying to parse startIndex and EndIndex: " + nfEx.getMessage());
                        throw new ServiceException(2);
                    }
                }
                if (endIndex <= startIndex) {
                    throw new ServiceException(2);
                }
                ListContentParser listContentParser = new ListContentParser();
                ListContentRequest listContentReq = new ListContentRequest(listContentParser, sessionKey, secret, aid);
                result = FacebookHttpUtil.doRequest(listContentReq, isRefreshForced.equalsIgnoreCase("true"));
                contentList = listContentParser.getEntries();
                String errorCode = listContentParser.getErrorCode();
                if (result == 0 && !errorCode.trim().equalsIgnoreCase("")) {
                    result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                    break block10;
                }
                if (result != 0) break block10;
                if (contentList != null) {
                    Log.trace(this, "Getting parsed entries. Number of entries: " + contentList.getTotalNrOfEntries());
                    int i = startIndex;
                    while (i < endIndex) {
                        Entry entry = contentList.getEntry(i);
                        if (entry == null) {
                            Log.trace(this, "Returned null content. Ending content list filling loop.");
                            endIndex = i;
                            break;
                        }
                        FacebookContent contentEntry = this.getContentImage(entry);
                        ActionData childData = listContentAction.addChildData();
                        partOutAttr = EntryCodec.encodeEntry(contentEntry);
                        childData.setAttributes(partOutAttr);
                        ++i;
                    }
                    Log.trace(this, "Ended parsing content entries with result " + result + ".");
                    outAttr.set("list:entry-count", String.valueOf(contentList.getTotalNrOfEntries()));
                    outAttr.set("list:start-entry", String.valueOf(startIndex));
                    outAttr.set("list:end-entry", String.valueOf(endIndex));
                    break block10;
                }
                throw new ServiceException(12);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing List Content Action Handler: " + se.getMessage());
                result = se.getResult();
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        listContentActionData.setAttributes(outAttr);
    }

    private void handleListCommentRequest(Action listCommentAction) {
        int result = 12;
        EntryList commentList = null;
        Attributes outAttr = new Attributes();
        Attributes partOutAttr = null;
        int startIndex = 0;
        int endIndex = Integer.MAX_VALUE;
        Vector<String> ownerVector = new Vector<String>();
        ActionData listCommentActionData = listCommentAction.getMainData();
        Attributes inAttr = listCommentActionData.getAttributes();
        String pid = inAttr.get("content:id");
        String isRefreshForced = inAttr.get("list:force-refresh");
        String startIndexStr = inAttr.get("list:start-entry");
        String endIndexStr = inAttr.get("list:end-entry");
        String sessionKey = this.rmsAuth.getSessionKey();
        String secret = this.rmsAuth.getSecret();
        try {
            this.checkParameters(sessionKey, secret, pid);
            if (startIndexStr != null && endIndexStr != null) {
                try {
                    startIndex = Integer.parseInt(startIndexStr);
                    endIndex = Integer.parseInt(endIndexStr);
                }
                catch (NumberFormatException nfEx) {
                    Log.error("Error trying to parse startIndex and EndIndex: " + nfEx.getMessage());
                    throw new ServiceException(2);
                }
            }
            if (endIndex <= startIndex) {
                throw new ServiceException(2);
            }
            ListCommentParser parser = new ListCommentParser();
            ListCommentRequest listCommReq = new ListCommentRequest(parser, sessionKey, secret, pid);
            result = FacebookHttpUtil.doRequest(listCommReq, isRefreshForced.equalsIgnoreCase("true"));
            commentList = parser.getEntries();
            String errorCode = parser.getErrorCode();
            int totalNrOfEntries = commentList.getTotalNrOfEntries();
            if (result == 0 && !errorCode.trim().equalsIgnoreCase("")) {
                result = FacebookErrors.getWebAlbumErrorCode(errorCode);
            } else if (result == 0 && commentList != null) {
                Log.trace(this, "Getting parsed entries. Number of entries: " + totalNrOfEntries);
                int i = 0;
                while (i < totalNrOfEntries) {
                    Entry entry = commentList.getEntry(i);
                    if (entry == null) {
                        Log.trace(this, "Returned null content. Ending content list filling loop.");
                        endIndex = i;
                        break;
                    }
                    FacebookComment commentEntry = (FacebookComment)entry;
                    ownerVector.addElement(commentEntry.getAuthorId());
                    ++i;
                }
                if (ownerVector != null && ownerVector.size() > 0) {
                    UserInfoParser userInfoParser = new UserInfoParser();
                    UserInfoRequest userInfoReq = new UserInfoRequest(userInfoParser, ownerVector, sessionKey, secret);
                    result = FacebookHttpUtil.doRequest(userInfoReq, isRefreshForced.equalsIgnoreCase("true"));
                    errorCode = userInfoParser.getErrorCode();
                    if (result == 0 && !errorCode.trim().equalsIgnoreCase("")) {
                        result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                    } else if (result == 0) {
                        if (endIndex > totalNrOfEntries) {
                            endIndex = totalNrOfEntries;
                        }
                        String[] userData = null;
                        int i2 = startIndex;
                        while (i2 < endIndex) {
                            FacebookComment commentEntry = (FacebookComment)commentList.getEntry(i2);
                            userData = userInfoParser.getOwnerData((String)ownerVector.elementAt(i2));
                            if (userData != null) {
                                commentEntry.setAuthorName(userData[0]);
                                commentEntry.setAuthorNickName(userData[1]);
                            }
                            ActionData childData = listCommentAction.addChildData();
                            partOutAttr = EntryCodec.encodeEntry(commentEntry);
                            childData.setAttributes(partOutAttr);
                            ++i2;
                        }
                    }
                }
                Log.trace(this, "Ended parsing content entries with result " + result + ".");
                outAttr.set("list:entry-count", String.valueOf(commentList.getTotalNrOfEntries()));
                outAttr.set("list:start-entry", String.valueOf(startIndex));
                outAttr.set("list:end-entry", String.valueOf(endIndex));
            } else if (result == 0 && commentList == null) {
                outAttr.set("list:entry-count", "0");
                outAttr.set("list:start-entry", "0");
                outAttr.set("list:end-entry", "0");
            }
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing List Comment Action Handler: " + se.getMessage());
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        listCommentActionData.setAttributes(outAttr);
    }

    private boolean isValidPidsVector(Vector pidsVector) {
        boolean result = false;
        int pidsVectorSize = pidsVector.size();
        int i = 0;
        while (i < pidsVectorSize) {
            if (pidsVector.elementAt(i) != null && !pidsVector.elementAt(i).toString().equalsIgnoreCase("0")) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private FacebookAlbum getAlbumCoverImage(Entry entry, ListContentParser listContentParser) {
        FacebookAlbum albumEntry = (FacebookAlbum)entry;
        ImageResource coverImage = null;
        String coverImageUrl = listContentParser.getPidThumbUrl(albumEntry.getCoverPhotoId());
        if (coverImageUrl != null && coverImageUrl.length() > 0) {
            coverImage = new ImageResource("cover-image", coverImageUrl, MimeUtil.getContentTypeFromUrl(coverImageUrl), 75, 75);
            albumEntry.addResource(coverImage);
        }
        if (ServiceUtils.isProfilePictures(albumEntry)) {
            albumEntry.setTitle(ServiceUtils.mapProfilePictureTitle(this.rmsAuth.getLocale()));
        }
        return albumEntry;
    }

    private FacebookContent getContentImage(Entry entry) {
        FacebookContent contentEntry = (FacebookContent)entry;
        ImageResource image = null;
        String imageUrl = contentEntry.getSrcBig();
        if (imageUrl != null && imageUrl.length() > 0) {
            image = new ImageResource("content", imageUrl, MimeUtil.getContentTypeFromUrl(imageUrl), 604, 604);
            contentEntry.addResource(image);
        }
        ImageResource thumbImg = null;
        String thumbUrl = contentEntry.getSrcSmall();
        if (thumbUrl != null && thumbUrl.length() > 0) {
            thumbImg = new ImageResource("thumbnail", thumbUrl, MimeUtil.getContentTypeFromUrl(thumbUrl), 75, 75);
            contentEntry.addResource(thumbImg);
        }
        return contentEntry;
    }

    private void checkParameters(String sessionKey, String secret, String id) throws ServiceException {
        if (sessionKey == null || sessionKey.trim().length() <= 0 || secret == null || secret.trim().length() <= 0) {
            Log.error("Invalid autorization parameters");
            throw new ServiceException(5);
        }
        if (id == null) {
            Log.error("Photo/Album ID is missing");
            throw new ServiceException(4);
        }
        if (id.trim().length() <= 0) {
            Log.error("Passed photo/album ID  is invalid");
            throw new ServiceException(2);
        }
    }
}

