/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.service.http.FacebookErrors;
import com.sonyericsson.facebook.service.http.FacebookHttpUtil;
import com.sonyericsson.facebook.service.http.RemoveRequest;
import com.sonyericsson.facebook.service.utils.ServiceUtils;
import com.sonyericsson.facebook.service.xml.RemoveParser;
import com.sonyericsson.facebook.utils.RMSAuth;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;

public class RemoveActionHandler
implements ActionHandler {
    private RMSAuth rmsAuth;
    private static final String REMOVE_ALBUM_RESPONSE_PATH = "/photos_deleteAlbum_response";
    private static final String REMOVE_CONTENT_RESPONSE_PATH = "/photos_deletePhoto_response";

    public void handleAction(Action action, ActionResponseListener responseListener) {
        block5: {
            int result = 12;
            ActionData actionData = action.getMainData();
            Attributes inAttr = actionData.getAttributes();
            String type = inAttr.get("item:type");
            Attributes outAttr = new Attributes();
            try {
                this.rmsAuth = RMSAuth.getRMSAuth();
                if (type == null) {
                    throw new ServiceException(4);
                }
                if (type.equalsIgnoreCase("album")) {
                    this.handleRemoveAlbumRequest(action);
                    break block5;
                }
                if (type.equalsIgnoreCase("content")) {
                    this.handleRemoveContentRequest(action);
                    break block5;
                }
                throw new ServiceException(3);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing Remove action handler: " + se.getMessage());
                result = se.getResult();
                outAttr.set("result", Result.toString(result), 0);
                actionData.setAttributes(outAttr);
            }
        }
        responseListener.actionCompleteNotify(action);
    }

    private void handleRemoveAlbumRequest(Action action) {
        int result = 12;
        ActionData mainData = action.getMainData();
        Attributes outAttr = new Attributes();
        String albumId = mainData.getAttributes().get("album:id");
        String sessionKey = this.rmsAuth.getSessionKey();
        String secret = this.rmsAuth.getSecret();
        try {
            if (sessionKey == null || secret == null || sessionKey.trim().length() <= 0 || secret.trim().length() <= 0) {
                Log.error("Invalid autorization parameters");
                throw new ServiceException(5);
            }
            if (albumId == null) {
                throw new ServiceException(4);
            }
            if (albumId.trim().length() <= 0) {
                throw new ServiceException(2);
            }
            if (ServiceUtils.isProfilePictures(albumId, this.rmsAuth.getSessionKey(), this.rmsAuth.getSecret())) {
                throw new ServiceException(3);
            }
            RemoveParser removeAlbumParser = new RemoveParser(REMOVE_ALBUM_RESPONSE_PATH);
            RemoveRequest removeAlbumReq = new RemoveRequest(removeAlbumParser, sessionKey, secret, albumId, null);
            result = FacebookHttpUtil.doRequest(removeAlbumReq);
            String errorCode = removeAlbumParser.getErrorCode();
            if (!errorCode.trim().equalsIgnoreCase("")) {
                result = FacebookErrors.getWebAlbumErrorCode(errorCode);
            }
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing Remove Album Action Handler: " + se.getMessage());
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        mainData.setAttributes(outAttr);
    }

    private void handleRemoveContentRequest(Action action) {
        int result = 12;
        ActionData mainData = action.getMainData();
        Attributes outAttr = new Attributes();
        String pid = mainData.getAttributes().get("content:id");
        String sessionKey = this.rmsAuth.getSessionKey();
        String secret = this.rmsAuth.getSecret();
        try {
            if (sessionKey == null || secret == null || sessionKey.trim().length() <= 0 || secret.trim().length() <= 0) {
                Log.error("Invalid autorization parameters");
                throw new ServiceException(5);
            }
            if (pid == null) {
                throw new ServiceException(4);
            }
            if (pid.trim().length() <= 0) {
                throw new ServiceException(2);
            }
            RemoveParser removeContentParser = new RemoveParser(REMOVE_CONTENT_RESPONSE_PATH);
            RemoveRequest removeContentReq = new RemoveRequest(removeContentParser, sessionKey, secret, null, pid);
            result = FacebookHttpUtil.doRequest(removeContentReq);
            String errorCode = removeContentParser.getErrorCode();
            if (!errorCode.trim().equalsIgnoreCase("")) {
                result = FacebookErrors.getWebAlbumErrorCode(errorCode);
            } else if (removeContentParser.getReturnMessage().equalsIgnoreCase("0")) {
                Log.error("Invalid content id, it does not correspond to any photo");
                result = 2;
            }
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing Remove Content Action Handler: " + se.getMessage());
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        mainData.setAttributes(outAttr);
    }
}

