/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.service.http.FacebookErrors;
import com.sonyericsson.facebook.service.http.FacebookHttpUtil;
import com.sonyericsson.facebook.service.http.SignInRequest;
import com.sonyericsson.facebook.service.http.UserInfoRequest;
import com.sonyericsson.facebook.service.xml.SignInParser;
import com.sonyericsson.facebook.service.xml.UserInfoParser;
import com.sonyericsson.facebook.utils.RMSAuth;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import java.util.Vector;

public class SignInActionHandler
implements ActionHandler {
    private RMSAuth rmsAuth;
    private static final String ATTR_USER_LOGIN = "user:login";
    private static final String ATTR_USER_PASSWORD = "user:password";
    private static final String ATTR_USER_NICKNAME = "user:nickname";
    private static final String ATTR_USER_NAME = "user:name";
    private static final String ATTR_AUTH_STATUS = "auth:status";
    private static final String VALUE_CREDENTIALS_STATUS_AUTHORIZED = "authorized";
    private static final String VALUE_CREDENTIALS_STATUS_BAD_CREDENTIALS = "bad credentials";

    public void handleAction(Action action, ActionResponseListener responseListener) {
        ActionData actionData;
        Attributes outAttr;
        int result;
        block12: {
            result = 12;
            String sessionKey = null;
            String uid = null;
            String secret = null;
            String name = null;
            String nickname = null;
            String errorCode = "";
            outAttr = new Attributes();
            actionData = action.getMainData();
            Attributes inAttr = actionData.getAttributes();
            String login = inAttr.get(ATTR_USER_LOGIN);
            String password = inAttr.get(ATTR_USER_PASSWORD);
            SignInParser parser = new SignInParser();
            try {
                this.rmsAuth = RMSAuth.getRMSAuth();
                if (login == null || password == null) {
                    throw new ServiceException(4);
                }
                if (login.trim().length() <= 0 || password.trim().length() <= 0) {
                    outAttr.set(ATTR_AUTH_STATUS, VALUE_CREDENTIALS_STATUS_BAD_CREDENTIALS);
                    outAttr.set(ATTR_USER_LOGIN, login);
                    throw new ServiceException(0);
                }
                SignInRequest signInReq = new SignInRequest(parser, login, password);
                result = FacebookHttpUtil.doRequest(signInReq);
                errorCode = parser.getErrorCode();
                if (result == 0 && !errorCode.trim().equalsIgnoreCase("")) {
                    result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                    if (result == 5) {
                        outAttr.set(ATTR_AUTH_STATUS, VALUE_CREDENTIALS_STATUS_BAD_CREDENTIALS);
                        outAttr.set(ATTR_USER_LOGIN, login);
                        throw new ServiceException(0);
                    }
                    break block12;
                }
                if (result != 0) break block12;
                sessionKey = parser.getSessionValue();
                uid = parser.getUidValue();
                secret = parser.getSecretValue();
                Log.trace(this, "Session key retrieved: " + sessionKey);
                Log.trace(this, "UID retrieved: " + uid);
                Log.trace(this, "Secret retrieved: " + secret);
                if (sessionKey != null && sessionKey.trim().length() > 0 && uid != null && uid.trim().length() > 0 && secret != null && secret.trim().length() > 0) {
                    this.rmsAuth.setSessionKey(sessionKey);
                    this.rmsAuth.setUid(uid);
                    this.rmsAuth.setSecret(secret);
                    this.rmsAuth.setName("");
                    this.rmsAuth.setNick("");
                    UserInfoParser userInfoParser = new UserInfoParser();
                    Vector<String> uidVector = new Vector<String>();
                    uidVector.addElement(uid);
                    UserInfoRequest userInfoReq = new UserInfoRequest(userInfoParser, uidVector, sessionKey, secret);
                    result = FacebookHttpUtil.doRequest(userInfoReq);
                    errorCode = userInfoParser.getErrorCode();
                    if (result == 0 && !errorCode.trim().equalsIgnoreCase("")) {
                        result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                    } else if (result == 0) {
                        name = userInfoParser.getUserName();
                        nickname = userInfoParser.getNickName();
                        this.rmsAuth.setLocale(userInfoParser.getLocale());
                        outAttr.set(ATTR_AUTH_STATUS, VALUE_CREDENTIALS_STATUS_AUTHORIZED);
                        if (name != null) {
                            this.rmsAuth.setName(name);
                            outAttr.set(ATTR_USER_NAME, name);
                        }
                        if (nickname != null) {
                            this.rmsAuth.setNick(nickname);
                            outAttr.set(ATTR_USER_NICKNAME, nickname);
                        }
                    }
                    break block12;
                }
                Log.trace("Failed to retrieve the responses for the sign-in request");
                throw new ServiceException(12);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing Sign-in Action Handler: " + se.getMessage());
                result = se.getResult();
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

