/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.service.http.EditAlbumRequest;
import com.sonyericsson.facebook.service.http.EditContentRequest;
import com.sonyericsson.facebook.service.http.FacebookErrors;
import com.sonyericsson.facebook.service.http.FacebookHttpUtil;
import com.sonyericsson.facebook.service.utils.ServiceUtils;
import com.sonyericsson.facebook.service.xml.EditAlbumParser;
import com.sonyericsson.facebook.service.xml.EditContentParser;
import com.sonyericsson.facebook.utils.RMSAuth;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;

public class UpdateActionHandler
implements ActionHandler {
    private RMSAuth rmsAuth;

    public void handleAction(Action action, ActionResponseListener responseListener) {
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Attributes outAttr = new Attributes();
        String type = inAttr.get("item:type");
        if (type == null) {
            outAttr.set("result", Result.toString(4), 0);
            actionData.setAttributes(outAttr);
        } else if (type.equalsIgnoreCase("album")) {
            this.handleUpdateAlbumRequest(action);
        } else if (type.equalsIgnoreCase("content")) {
            this.handleUpdateContentRequest(action);
        } else {
            outAttr.set("result", Result.toString(3), 0);
            actionData.setAttributes(outAttr);
        }
        responseListener.actionCompleteNotify(action);
    }

    private void handleUpdateAlbumRequest(Action updateAlbumAction) {
        int result = 12;
        Attributes outAttr = new Attributes();
        String albumId = null;
        String albumTitle = null;
        String albumDescription = null;
        String albumLocation = null;
        String errorCode = "";
        ActionData updateAlbumActionData = updateAlbumAction.getMainData();
        Attributes inAttr = updateAlbumActionData.getAttributes();
        albumId = inAttr.get("album:id");
        albumTitle = inAttr.get("album:title");
        albumDescription = inAttr.get("album:description");
        albumLocation = inAttr.get("album:location");
        if (albumDescription == null) {
            albumDescription = "";
        }
        try {
            this.rmsAuth = RMSAuth.getRMSAuth();
            if (this.rmsAuth.getSessionKey() == null || this.rmsAuth.getSessionKey().trim().length() == 0 || this.rmsAuth.getSecret() == null || this.rmsAuth.getSecret().trim().length() == 0) {
                Log.error(this, "No Session Key found in database. Not authorized to edit albums.");
                throw new ServiceException(5);
            }
            if (albumTitle == null || albumId == null) {
                throw new ServiceException(4);
            }
            if (albumTitle.trim().length() == 0 || albumId.trim().length() == 0) {
                throw new ServiceException(2);
            }
            if (ServiceUtils.isProfilePictures(albumId, this.rmsAuth.getSessionKey(), this.rmsAuth.getSecret())) {
                throw new ServiceException(3);
            }
            EditAlbumParser parser = new EditAlbumParser();
            EditAlbumRequest editAlbumReq = new EditAlbumRequest(parser, this.rmsAuth, albumId, albumTitle, albumDescription, albumLocation);
            result = FacebookHttpUtil.doRequest(editAlbumReq);
            errorCode = parser.getErrorCode();
            if (errorCode != null && !errorCode.trim().equalsIgnoreCase("")) {
                throw new ServiceException(FacebookErrors.getWebAlbumErrorCode(errorCode));
            }
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing Edit Album Action Handler: " + se.getMessage());
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        updateAlbumActionData.setAttributes(outAttr);
    }

    private void handleUpdateContentRequest(Action updateContentAction) {
        int result = 12;
        ActionData mainData = updateContentAction.getMainData();
        Attributes inAttr = mainData.getAttributes();
        Attributes outAttr = new Attributes();
        String sessionKey = null;
        String secret = null;
        String pid = inAttr.get("content:id");
        String caption = inAttr.get("content:description");
        try {
            this.rmsAuth = RMSAuth.getRMSAuth();
            sessionKey = this.rmsAuth.getSessionKey();
            secret = this.rmsAuth.getSecret();
            if (sessionKey == null || secret == null || sessionKey.trim().length() <= 0 || secret.trim().length() <= 0) {
                Log.error("Invalid autorization parameters");
                throw new ServiceException(5);
            }
            if (pid == null || caption == null) {
                throw new ServiceException(4);
            }
            if (pid.trim().length() <= 0) {
                throw new ServiceException(2);
            }
            EditContentParser editContParser = new EditContentParser();
            EditContentRequest editContReq = new EditContentRequest(editContParser, sessionKey, secret, pid, caption);
            result = FacebookHttpUtil.doRequest(editContReq);
            String errorCode = editContParser.getErrorCode();
            if (!errorCode.trim().equalsIgnoreCase("")) {
                result = FacebookErrors.getWebAlbumErrorCode(errorCode);
            }
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing Update Action Handler: " + se.getMessage());
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        mainData.setAttributes(outAttr);
    }
}

