/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.model.FacebookUploadItem;
import com.sonyericsson.facebook.service.action.UploadJob;
import com.sonyericsson.facebook.service.config.Config;
import com.sonyericsson.facebook.service.utils.ServiceUtils;
import com.sonyericsson.facebook.utils.RMSAuth;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.job.JobManager;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.UploadItem;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.TransferJobResponseHandler;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.util.MediaUtil;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.MediaException;

public class UploadActionHandler
implements ActionHandler,
ActionResponseListener {
    private JobManager jobManager;
    private ActionResponseListener mainResponseListener;
    private Hashtable uploadJobHash = new Hashtable();
    private RMSAuth rmsAuth;

    public UploadActionHandler(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        String albumId = null;
        String type = null;
        this.mainResponseListener = responseListener;
        ActionData mainData = action.getMainData();
        Attributes mainInAttr = mainData.getAttributes();
        String baseDir = mainData.getUrl();
        String sessionKey = null;
        String secret = null;
        int transferId = -1;
        try {
            this.rmsAuth = RMSAuth.getRMSAuth();
            sessionKey = this.rmsAuth.getSessionKey();
            secret = this.rmsAuth.getSecret();
            int count = action.getChildDataCount();
            UploadItem[] items = new FacebookUploadItem[count];
            if (baseDir == null) {
                throw new ServiceException(4);
            }
            try {
                transferId = Integer.parseInt(mainInAttr.get("transfer:id"));
                if (-1 == transferId) {
                    throw new ServiceException(2);
                }
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException(2);
            }
            if (sessionKey == null || sessionKey.trim().length() == 0 || secret == null || secret.trim().length() == 0) {
                throw new ServiceException(5);
            }
            int i = 0;
            while (i < count) {
                block21: {
                    ActionData childData = action.getChildData(i);
                    Entry entry = EntryCodec.decodeEntry(childData.getAttributes());
                    String localUrl = childData.getUrl();
                    String tempUrl = null;
                    String contentType = UploadJob.getContentType(localUrl);
                    type = UploadJob.getType(contentType);
                    if (type.equalsIgnoreCase("video")) {
                        albumId = "NO_ALBUM_ID";
                    } else if (type.equalsIgnoreCase("image")) {
                        albumId = childData.getAttributes().get("album:id");
                    }
                    Log.trace("Album id in request: " + albumId);
                    if (albumId != "NO_ALBUM_ID" && ServiceUtils.isProfilePictures(albumId, sessionKey, secret)) {
                        throw new ServiceException(3);
                    }
                    if (contentType == null || contentType.equalsIgnoreCase("")) {
                        throw new ServiceException(4);
                    }
                    items[i] = new FacebookUploadItem(entry);
                    try {
                        if (entry instanceof Content && localUrl != null) {
                            if ("image/jpeg".equals(contentType)) {
                                tempUrl = this.createTempUrl(baseDir);
                                int maxWidthOrHeight = Math.min(604, Config.getPhotoUploadSize());
                                try {
                                    if (MediaUtil.resizeImage(localUrl, contentType, maxWidthOrHeight, tempUrl)) {
                                        Log.trace("Image resized. New url: " + tempUrl);
                                        Log.trace("New image longest dimension: " + maxWidthOrHeight);
                                        localUrl = tempUrl;
                                    }
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    Log.error(this, "IOException: Error resizing the Image before upload.");
                                    throw new ServiceException(9);
                                }
                                catch (MediaException e) {
                                    Log.error(this, "MediaException: Error resizing the Image before upload. Exception message: " + e.getMessage());
                                    throw new ServiceException(9);
                                }
                            }
                            Resource resource = new Resource("content");
                            resource.setLocalUrl(localUrl);
                            entry.addResource(resource);
                            ((FacebookUploadItem)items[i]).setContentType(contentType);
                            items[i].setState(1);
                            break block21;
                        }
                        Log.error(this, "Invalid entry item passed for uploading.");
                        throw new ServiceException(9);
                    }
                    catch (ServiceException se) {
                        items[i].setState(4);
                    }
                }
                ++i;
            }
            UploadJob uj = new UploadJob(transferId, items, secret, sessionKey);
            uj.setTransferJobListener(new TransferJobResponseHandler(action, this));
            this.uploadJobHash.put(new Integer(transferId), uj);
            this.jobManager.addJob(uj);
        }
        catch (ServiceException se) {
            int result = se.getResult();
            Attributes outAttr = new Attributes();
            outAttr.set("result", Result.toString(result), 0);
            mainData.setAttributes(outAttr);
            this.mainResponseListener.actionCompleteNotify(action);
        }
    }

    public void actionCompleteNotify(Action action) {
        this.mainResponseListener.actionCompleteNotify(action);
    }

    public void actionProgressNotify(Action action) {
        this.mainResponseListener.actionProgressNotify(action);
    }

    private String createTempUrl(String baseDir) {
        return String.valueOf(this.getFullDir(baseDir, "temp")) + "/temp" + System.currentTimeMillis();
    }

    private String getFullDir(String baseDir, String dir) {
        String fullDir;
        block6: {
            fullDir = baseDir.endsWith("/") ? String.valueOf(baseDir) + dir : String.valueOf(baseDir) + "/" + dir;
            FileConnection fc = null;
            try {
                try {
                    fc = (FileConnection)Connector.open((String)fullDir);
                    if (!fc.exists()) {
                        fc.mkdir();
                    }
                }
                catch (IOException iOException) {
                    IOUtil.closeConnection((Connection)fc);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeConnection(fc);
                throw throwable;
            }
            IOUtil.closeConnection((Connection)fc);
        }
        return fullDir;
    }
}

