/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.action;

import com.sonyericsson.facebook.model.FacebookUploadItem;
import com.sonyericsson.facebook.service.http.UploadPhotoRequest;
import com.sonyericsson.facebook.service.http.UploadVideoRequest;
import com.sonyericsson.facebook.service.xml.UploadParser;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.UploadItem;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.TransferJob;
import com.sonyericsson.webalbum.service.transfer.TransferRequestProgressListener;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.util.MimeUtil;
import java.util.Vector;

public class UploadJob
extends TransferJob
implements TransferRequestProgressListener {
    private static final int UPLOAD_PROGRESS_INTERVAL = 10240;
    private String secret;
    private String sessionKey;
    private Vector uploadedPhotoIdVector = new Vector();

    protected UploadJob(int id, UploadItem[] items, String secret, String sessionKey) {
        super(id, items);
        this.secret = secret;
        this.sessionKey = sessionKey;
    }

    protected int transferCurrentItem() {
        int result = 12;
        String type = null;
        int fileSize = 0;
        FacebookUploadItem item = (FacebookUploadItem)this.getCurrentItem();
        Content content = (Content)item.getEntry();
        String contentType = item.getContentType();
        type = UploadJob.getType(contentType);
        UploadParser upParser = new UploadParser(type);
        item.setState(2);
        try {
            try {
                Log.trace("UploadJob#uploadContent: Starting upload");
                Resource resource = content.getResource("content");
                if (resource == null || content.getAlbumId() == null) {
                    throw new ServiceException(2);
                }
                String localUrl = resource.getLocalUrl();
                if (localUrl == null) {
                    throw new ServiceException(2);
                }
                fileSize = IOUtil.getFileSize(localUrl);
                item.setTotalNrBytes(fileSize);
                if (type.equalsIgnoreCase("video")) {
                    this.currentRequest = new UploadVideoRequest(upParser, content, this.secret, this.sessionKey, contentType);
                } else if (type.equalsIgnoreCase("image")) {
                    this.currentRequest = new UploadPhotoRequest(upParser, content, this.secret, this.sessionKey, contentType);
                }
                this.currentRequest.setTransferRequestProgressListener(this, 10240);
                if (this.cancelled) {
                    this.currentRequest.cancel();
                } else if (type.equalsIgnoreCase("video")) {
                    result = ((UploadVideoRequest)this.currentRequest).doRequest();
                } else if (type.equalsIgnoreCase("image")) {
                    result = ((UploadPhotoRequest)this.currentRequest).doRequest();
                }
            }
            catch (ServiceException e) {
                Log.error("Error in upload request process");
                Log.logException(e);
                result = e.getResult();
                if (result == 0) {
                    item.setCurrentNrBytes(fileSize);
                    item.setState(5);
                    if (type.equalsIgnoreCase("image")) {
                        this.uploadedPhotoIdVector.addElement(upParser.getPidValue());
                    } else if (type.equalsIgnoreCase("video")) {
                        this.uploadedPhotoIdVector.addElement(upParser.getVideoIdValue());
                    }
                } else if (this.currentRequest != null && this.currentRequest.isCancelled()) {
                    item.setState(3);
                    result = 1;
                } else {
                    item.setState(4);
                }
                this.currentRequest = null;
            }
        }
        finally {
            if (result == 0) {
                item.setCurrentNrBytes(fileSize);
                item.setState(5);
                if (type.equalsIgnoreCase("image")) {
                    this.uploadedPhotoIdVector.addElement(upParser.getPidValue());
                } else if (type.equalsIgnoreCase("video")) {
                    this.uploadedPhotoIdVector.addElement(upParser.getVideoIdValue());
                }
            } else if (this.currentRequest != null && this.currentRequest.isCancelled()) {
                item.setState(3);
                result = 1;
            } else {
                item.setState(4);
            }
            this.currentRequest = null;
        }
        return result;
    }

    public static String getContentType(String localUrl) {
        int lastDotPos;
        String contentType = MimeUtil.getContentTypeFromUrl(localUrl);
        if (contentType == "" && (lastDotPos = localUrl.lastIndexOf(46)) >= 0) {
            if (localUrl.substring(lastDotPos).equalsIgnoreCase(".mp4")) {
                contentType = "video/mp4";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".3gp") || localUrl.substring(lastDotPos).equalsIgnoreCase(".3gpp")) {
                contentType = "video/3gpp";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".3g2")) {
                contentType = "video/3gpp2";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".wmv")) {
                contentType = "video/x-ms-wmv";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".avi")) {
                contentType = "video/avi";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".asf")) {
                contentType = "video/x-ms-asf";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".flv")) {
                contentType = "video/x-flv";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".m4v")) {
                contentType = "video/x-m4v";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".mkv")) {
                contentType = "video/x-matroska";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".nsv")) {
                contentType = "x-winamp";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".mov") || localUrl.substring(lastDotPos).equalsIgnoreCase(".qt")) {
                contentType = "video/quicktime";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".mpe") || localUrl.substring(lastDotPos).equalsIgnoreCase(".vob")) {
                contentType = "video/mpeg";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".tif") || localUrl.substring(lastDotPos).equalsIgnoreCase(".tiff")) {
                contentType = "image/tiff";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".jp2")) {
                contentType = "image/jp2";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".iff")) {
                contentType = "image/iff";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".wbmp")) {
                contentType = "image/vnd.wap.wbmp";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".xbm")) {
                contentType = "image/x-xbitmap";
            }
        }
        return contentType;
    }

    public static String getType(String contentType) {
        String type = null;
        int barPos = -1;
        barPos = contentType.lastIndexOf(47);
        if (barPos >= 0) {
            type = contentType.substring(0, barPos);
        }
        return type;
    }

    public Vector getUploadedPhotoIdVector() {
        return this.uploadedPhotoIdVector;
    }
}

