/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.http;

import com.sonyericsson.facebook.service.http.FacebookRequest;
import com.sonyericsson.facebook.service.utils.ServiceUtils;
import com.sonyericsson.facebook.service.xml.AddCommentParser;
import com.sonyericsson.facebook.utils.MD5HashGenerator;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.StringMap;
import com.sonyericsson.webalbum.util.StringUtil;
import java.io.UnsupportedEncodingException;

public class AddCommentRequest
extends FacebookRequest {
    private static final String ADD_COMMENT_METHOD = "facebook.photos.addComment";
    private String sessionKey = null;
    private String secret = null;
    private String photoId = null;
    private String commentTxt = null;
    private String callId = this.getTime();

    public AddCommentRequest(AddCommentParser parser, String sessionKey, String secret, String photoId, String commentText) {
        super(parser);
        StringMap requestMap = new StringMap();
        String request = null;
        if (sessionKey != null && sessionKey.trim().length() > 0 && secret != null && secret.trim().length() > 0 && photoId != null && photoId.trim().length() > 0) {
            this.sessionKey = sessionKey;
            this.secret = secret;
            this.photoId = photoId;
            this.commentTxt = commentText;
            requestMap.put("api_key", "7a9abb81c85b92c5e02e427242652c24");
            requestMap.put("session_key", this.sessionKey);
            requestMap.put("call_id", String.valueOf(this.callId));
            requestMap.put("v", "1.0");
            requestMap.put("method", ADD_COMMENT_METHOD);
            requestMap.put("pid", this.photoId);
            if (this.commentTxt != null && this.commentTxt.trim().length() > 0) {
                this.commentTxt = ServiceUtils.replaceParagraphChars(this.commentTxt);
                requestMap.put("body", ServiceUtils.EscapeCharacter(this.commentTxt));
            }
            requestMap.put("sig", this.getApiSig());
            try {
                request = StringUtil.encodeKeyValueString(requestMap, "&", null);
            }
            catch (UnsupportedEncodingException uee) {
                Log.error(this, "Unexpected UnsupportedEncodingException thrown when building request: " + uee.getMessage());
                throw new IllegalArgumentException("Error when trying to build the request");
            }
            if (request != null) {
                this.requestUrl = "https://api.facebook.com/restserver.php?" + request;
                Log.trace(this, "Add Comment request to send: " + this.requestUrl);
                try {
                    this.bodyBytes = request.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log.error(this, "UnsupportedEncodingException converting string to bytes (UTF-8): " + e.getMessage());
                    throw new IllegalArgumentException("UnsupportedEncodingException converting string to bytes (UTF-8)");
                }
                this.addHeader("Content-Type", "application/x-www-form-urlencoded");
                this.addHeader("Content-Length", String.valueOf(this.bodyBytes.length));
            }
        } else {
            Log.error(this, "Invalid parameters passed in constructor.");
            throw new IllegalArgumentException("Invalid parameters passed in constructor.");
        }
    }

    private String getApiSig() {
        String md5ApiSig = "";
        StringBuffer inputMD5String = new StringBuffer();
        inputMD5String.append("api_key").append("=").append("7a9abb81c85b92c5e02e427242652c24");
        inputMD5String.append("body").append("=").append(this.commentTxt);
        inputMD5String.append("call_id").append("=").append(this.callId);
        inputMD5String.append("method").append("=").append(ADD_COMMENT_METHOD);
        inputMD5String.append("pid").append("=").append(this.photoId);
        inputMD5String.append("session_key").append("=").append(this.sessionKey);
        inputMD5String.append("v").append("=").append("1.0");
        inputMD5String.append(this.secret);
        md5ApiSig = MD5HashGenerator.generateMD5(inputMD5String.toString());
        Log.trace(this, "Signature generated: " + md5ApiSig);
        return md5ApiSig;
    }
}

