/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.http;

import com.sonyericsson.facebook.service.http.FacebookRequest;
import com.sonyericsson.facebook.service.utils.ServiceUtils;
import com.sonyericsson.facebook.service.xml.EditAlbumParser;
import com.sonyericsson.facebook.utils.MD5HashGenerator;
import com.sonyericsson.facebook.utils.RMSAuth;
import com.sonyericsson.webalbum.log.Log;
import java.io.UnsupportedEncodingException;

public class EditAlbumRequest
extends FacebookRequest {
    private static final String EDIT_ALBUM_METHOD = "facebook.photos.editAlbum";
    private String callId = this.getTime();
    private String sessionKey = null;
    private String secret = null;
    private String albumId = null;
    private String albumTitle = null;
    private String albumDescr = null;
    private String albumLocation = null;

    public EditAlbumRequest(EditAlbumParser parser, RMSAuth rmsAuth, String albumId, String albumTitle, String albumDescription, String albumLocation) {
        super(parser);
        if (parser != null && rmsAuth != null && albumId != null && albumTitle != null) {
            this.sessionKey = rmsAuth.getSessionKey();
            this.secret = rmsAuth.getSecret();
            this.albumId = albumId;
            this.albumTitle = albumTitle;
            this.albumDescr = albumDescription != null ? ServiceUtils.replaceParagraphChars(albumDescription) : "";
            this.albumLocation = albumLocation;
            String apiSig = this.getApiSig();
            StringBuffer bodySb = new StringBuffer();
            bodySb.append("method").append("=").append(EDIT_ALBUM_METHOD);
            bodySb.append("&").append("aid").append("=").append(this.albumId);
            bodySb.append("&").append("description").append("=").append(ServiceUtils.EscapeCharacter(this.albumDescr));
            if (albumLocation != null && albumLocation.trim().length() > 0) {
                bodySb.append("&").append("location").append("=").append(ServiceUtils.EscapeCharacter(this.albumLocation));
            }
            bodySb.append("&").append("name").append("=").append(ServiceUtils.EscapeCharacter(this.albumTitle));
            bodySb.append("&").append("api_key").append("=").append("7a9abb81c85b92c5e02e427242652c24");
            bodySb.append("&").append("session_key").append("=").append(this.sessionKey);
            bodySb.append("&").append("call_id").append("=").append(this.callId);
            bodySb.append("&").append("v").append("=").append("1.0");
            bodySb.append("&").append("sig").append("=").append(apiSig);
            String bodyString = bodySb.toString();
            this.requestUrl = "https://api.facebook.com/restserver.php?" + bodyString;
            try {
                this.bodyBytes = bodyString.getBytes("UTF-8");
                Log.trace(this, "Request to send: " + bodyString);
            }
            catch (UnsupportedEncodingException e) {
                Log.error(this, "UnsupportedEncodingException converting string to bytes (UTF-8): " + e.getMessage());
                throw new IllegalArgumentException("UnsupportedEncodingException converting string to bytes (UTF-8)");
            }
        } else {
            Log.error(this, "Invalid parameters passed in constructor.");
            throw new IllegalArgumentException("Invalid parameters passed in constructor.");
        }
        this.addHeader("Content-Type", "application/x-www-form-urlencoded");
        this.addHeader("Content-Length", String.valueOf(this.bodyBytes.length));
    }

    private String getApiSig() {
        StringBuffer sequenceSb = new StringBuffer();
        sequenceSb.append("aid").append("=").append(this.albumId);
        sequenceSb.append("api_key").append("=").append("7a9abb81c85b92c5e02e427242652c24");
        sequenceSb.append("call_id").append("=").append(this.callId);
        sequenceSb.append("description").append("=").append(this.albumDescr);
        if (this.albumLocation != null && this.albumLocation.trim().length() > 0) {
            sequenceSb.append("location").append("=").append(this.albumLocation);
        }
        sequenceSb.append("method").append("=").append(EDIT_ALBUM_METHOD);
        sequenceSb.append("name").append("=").append(this.albumTitle);
        sequenceSb.append("session_key").append("=").append(this.sessionKey);
        sequenceSb.append("v").append("=").append("1.0");
        sequenceSb.append(this.secret);
        String sequenceString = sequenceSb.toString();
        Log.trace(this, "Sequence String generated: " + sequenceString);
        String apiSig = MD5HashGenerator.generateMD5(sequenceString);
        return apiSig;
    }
}

