/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.http;

import com.sonyericsson.facebook.service.http.FacebookRequest;
import com.sonyericsson.facebook.service.utils.ServiceUtils;
import com.sonyericsson.facebook.service.xml.EditContentParser;
import com.sonyericsson.facebook.utils.MD5HashGenerator;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.StringMap;
import com.sonyericsson.webalbum.util.StringUtil;
import java.io.UnsupportedEncodingException;

public class EditContentRequest
extends FacebookRequest {
    private static final String EDIT_CONTENT_METHOD = "facebook.photos.editPhoto";
    private String callId = this.getTime();
    private String sessionKey = null;
    private String secret = null;
    private String pid = null;
    private String description = null;

    public EditContentRequest(EditContentParser parser, String sessionKey, String secret, String pid, String caption) {
        super(parser);
        if (sessionKey != null && sessionKey.length() > 0 && secret != null && secret.length() > 0 && pid != null && pid.length() > 0 && caption != null) {
            this.sessionKey = sessionKey;
            this.secret = secret;
            this.pid = pid;
            this.description = caption;
            this.description = ServiceUtils.replaceParagraphChars(this.description);
            StringMap requestMap = new StringMap();
            String request = null;
            requestMap.put("api_key", "7a9abb81c85b92c5e02e427242652c24");
            requestMap.put("call_id", this.callId);
            requestMap.put("caption", ServiceUtils.EscapeCharacter(this.description));
            requestMap.put("method", EDIT_CONTENT_METHOD);
            requestMap.put("pid", this.pid);
            requestMap.put("session_key", this.sessionKey);
            requestMap.put("sig", this.getApiSig());
            requestMap.put("v", "1.0");
            try {
                request = StringUtil.encodeKeyValueString(requestMap, "&", null);
            }
            catch (UnsupportedEncodingException uee) {
                Log.error(this, "Unexpected UnsupportedEncodingException thrown when building request: " + uee.getMessage());
                throw new IllegalArgumentException("Error when trying to build the request");
            }
            if (request != null) {
                this.requestUrl = "https://api.facebook.com/restserver.php?" + request;
                Log.trace(this, "Request to send: " + request);
                try {
                    this.bodyBytes = request.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log.error(this, "UnsupportedEncodingException converting string to bytes (UTF-8): " + e.getMessage());
                    throw new IllegalArgumentException("UnsupportedEncodingException converting string to bytes (UTF-8)");
                }
                this.addHeader("Content-Type", "application/x-www-form-urlencoded");
                this.addHeader("Content-Length", String.valueOf(this.bodyBytes.length));
            } else {
                Log.error(this, "Invalid parameters passed in constructor.");
                throw new IllegalArgumentException("Invalid parameters passed in constructor.");
            }
        }
    }

    private String getApiSig() {
        StringBuffer sequenceSb = new StringBuffer();
        sequenceSb.append("api_key").append("=").append("7a9abb81c85b92c5e02e427242652c24");
        sequenceSb.append("call_id").append("=").append(this.callId);
        sequenceSb.append("caption").append("=").append(this.description);
        sequenceSb.append("method").append("=").append(EDIT_CONTENT_METHOD);
        sequenceSb.append("pid").append("=").append(this.pid);
        sequenceSb.append("session_key").append("=").append(this.sessionKey);
        sequenceSb.append("v").append("=").append("1.0");
        sequenceSb.append(this.secret);
        String sequenceString = sequenceSb.toString();
        Log.trace(this, "Sequence String generated: " + sequenceString);
        String apiSig = MD5HashGenerator.generateMD5(sequenceString);
        return apiSig;
    }
}

