/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.http;

import com.sonyericsson.webalbum.log.Log;

public class FacebookErrors {
    public static int getWebAlbumErrorCode(String facebookErrorCode) {
        int errorMsg = 12;
        int errorInt = -1;
        try {
            errorInt = Integer.parseInt(facebookErrorCode);
        }
        catch (NumberFormatException nfe) {
            Log.error("NumberFormatException trying to parse passed error code " + facebookErrorCode + ": " + nfe.getMessage());
        }
        switch (errorInt) {
            case 2: {
                errorMsg = 6;
                break;
            }
            case 4: 
            case 5: 
            case 102: 
            case 200: 
            case 400: 
            case 401: {
                errorMsg = 5;
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 120: 
            case 121: 
            case 221: 
            case 324: 
            case 325: {
                errorMsg = 2;
                break;
            }
            case 321: {
                errorMsg = 11;
                break;
            }
            default: {
                Log.error("Unknown error in response from Facebook.");
            }
        }
        return errorMsg;
    }
}

