/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.http;

import com.sonyericsson.facebook.service.xml.FacebookParser;
import com.sonyericsson.facebook.utils.MD5HashGenerator;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.transfer.TransferRequest;
import com.sonyericsson.webalbum.util.CacheUtil;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.xml.XmlException;
import com.sonyericsson.webalbum.xml.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import javax.microedition.io.file.FileConnection;

public abstract class FacebookRequest
extends TransferRequest {
    protected XmlParser parser;
    protected byte[] bodyBytes;
    protected String requestUrl;

    public FacebookRequest(FacebookParser parser) {
        super("POST", "https://api.facebook.com/restserver.php", new Hashtable(), 1024);
        this.parser = parser;
    }

    public FacebookRequest(XmlParser parser, String postUrl) {
        super("POST", postUrl, new Hashtable(), 1024);
        this.parser = parser;
    }

    public FacebookRequest(String method, String url, Hashtable headers, int bufSize) {
        super(method, url, headers, bufSize);
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void writeBody(OutputStream os) throws IOException {
        os.write(this.bodyBytes);
    }

    public void readResponseBody(InputStream is) throws IOException {
        if (this.getResponseCode() == 200) {
            this.parseResponse(is);
        }
    }

    public void parseResponse(InputStream is) throws IOException {
        try {
            this.parser.parse(is);
        }
        catch (XmlException e) {
            Log.error(this, "XmlException parsing response: " + e.getMessage());
            Log.logException(e);
        }
    }

    public String getTime() {
        String time = "";
        Calendar calendar = Calendar.getInstance();
        Date currentTime = calendar.getTime();
        time = Long.toString(currentTime.getTime());
        return time;
    }

    protected InputStream cacheResponse(InputStream is) {
        InputStream returnIs = null;
        String localUrl = null;
        int mStartIndex = this.requestUrl.indexOf("method");
        int mEndIndex = this.requestUrl.indexOf("&", mStartIndex);
        int sessionStartIndex = this.requestUrl.indexOf("session_key");
        int sessionEndIndex = this.requestUrl.indexOf("&", sessionStartIndex);
        int aidStartIndex = this.requestUrl.indexOf("aid");
        int pidStartIndex = this.requestUrl.indexOf("pid");
        String tempCacheUrl = "";
        if (-1 != aidStartIndex) {
            int aidEndIndex = this.requestUrl.indexOf("&", aidStartIndex);
            tempCacheUrl = this.requestUrl.substring(mStartIndex, mEndIndex + 1).concat(this.requestUrl.substring(sessionStartIndex, sessionEndIndex + 1).concat(this.requestUrl.substring(aidStartIndex, aidEndIndex)));
        } else if (-1 != pidStartIndex) {
            int pidEndIndex = this.requestUrl.indexOf("&", pidStartIndex);
            tempCacheUrl = this.requestUrl.substring(mStartIndex, mEndIndex + 1).concat(this.requestUrl.substring(sessionStartIndex, sessionEndIndex + 1).concat(this.requestUrl.substring(pidStartIndex, pidEndIndex)));
        } else {
            tempCacheUrl = this.requestUrl.substring(mStartIndex, mEndIndex + 1).concat(this.requestUrl.substring(sessionStartIndex, sessionEndIndex));
        }
        this.requestUrl = tempCacheUrl;
        localUrl = CacheUtil.getCachedFileUrl(this.requestUrl);
        if (localUrl == null) {
            Log.error(this, "Failed to create local cache.");
            returnIs = is;
        } else {
            FileConnection cacheFconn = null;
            OutputStream os = null;
            try {
                try {
                    String tempLocalUrl = localUrl;
                    localUrl = MD5HashGenerator.generateMD5(tempLocalUrl);
                    localUrl = String.valueOf(CacheUtil.getCacheDirUrl()) + localUrl + ".cache";
                    cacheFconn = CacheUtil.createCachedFile(localUrl);
                    os = cacheFconn.openOutputStream();
                    IOUtil.copyStream(is, os);
                    os.flush();
                    os.close();
                    CacheUtil.markCachedFileAsValid(localUrl);
                    returnIs = cacheFconn.openInputStream();
                }
                catch (IOException ioe) {
                    Log.error(this, "IOException saving response to cache: " + ioe.getMessage());
                    returnIs = is;
                    try {
                        os.flush();
                        os.close();
                    }
                    catch (IOException ioe2) {
                        Log.error(this, "IOException saving response to cache: " + ioe2.getMessage());
                    }
                }
            }
            finally {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException ioe) {
                    Log.error(this, "IOException saving response to cache: " + ioe.getMessage());
                }
            }
        }
        return returnIs;
    }

    public String mapVisibility(String permission) {
        String visibility = "";
        visibility = permission.equalsIgnoreCase("public") ? "everyone" : (permission.equalsIgnoreCase("contacts") ? "friends" : "");
        return visibility;
    }
}

