/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.http;

import com.sonyericsson.facebook.service.http.FacebookRequest;
import com.sonyericsson.facebook.service.xml.ListAlbumParser;
import com.sonyericsson.facebook.utils.MD5HashGenerator;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.StringMap;
import com.sonyericsson.webalbum.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class ListAlbumRequest
extends FacebookRequest {
    private static final String LIST_ALBUM_METHOD = "photos.getAlbums";
    private String callId = this.getTime();
    private String sessionKey = null;
    private String secret = null;
    private String aids = null;

    public ListAlbumRequest(ListAlbumParser parser, String sessionKey, String secret, String aids) {
        super(parser);
        if (sessionKey != null && sessionKey.length() > 0 && secret != null && secret.length() > 0) {
            StringMap requestMap = new StringMap();
            String request = null;
            this.sessionKey = sessionKey;
            this.secret = secret;
            this.aids = aids;
            if (this.aids != null) {
                requestMap.put("aids", this.aids);
            }
            requestMap.put("method", LIST_ALBUM_METHOD);
            requestMap.put("api_key", "7a9abb81c85b92c5e02e427242652c24");
            requestMap.put("session_key", this.sessionKey);
            requestMap.put("call_id", this.callId);
            requestMap.put("v", "1.0");
            requestMap.put("sig", this.getApiSig());
            try {
                request = StringUtil.encodeKeyValueString(requestMap, "&", null);
            }
            catch (UnsupportedEncodingException uee) {
                Log.error(this, "Unexpected UnsupportedEncodingException thrown when building request: " + uee.getMessage());
                throw new IllegalArgumentException("Error when trying to build the request");
            }
            if (request != null) {
                this.requestUrl = "https://api.facebook.com/restserver.php?" + request;
                Log.trace(this, "Request to send: " + request);
                try {
                    this.bodyBytes = request.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log.error(this, "UnsupportedEncodingException converting string to bytes (UTF-8): " + e.getMessage());
                    throw new IllegalArgumentException("UnsupportedEncodingException converting string to bytes (UTF-8)");
                }
                this.addHeader("Content-Type", "application/x-www-form-urlencoded");
                this.addHeader("Content-Length", String.valueOf(this.bodyBytes.length));
            }
        } else {
            Log.error(this, "Invalid parameters passed in constructor.");
            throw new IllegalArgumentException("Invalid parameters passed in constructor.");
        }
    }

    public void readResponseBody(InputStream is) throws IOException {
        if (this.getResponseCode() == 200) {
            InputStream responseIs = this.cacheResponse(is);
            if (responseIs != null) {
                this.parseResponse(responseIs);
            } else {
                Log.error(this, "Failed to cache XML response.");
            }
        }
    }

    private String getApiSig() {
        StringBuffer sequenceSb = new StringBuffer();
        if (this.aids != null) {
            sequenceSb.append("aids").append("=").append(this.aids);
        }
        sequenceSb.append("api_key").append("=").append("7a9abb81c85b92c5e02e427242652c24");
        sequenceSb.append("call_id").append("=").append(this.callId);
        sequenceSb.append("method").append("=").append(LIST_ALBUM_METHOD);
        sequenceSb.append("session_key").append("=").append(this.sessionKey);
        sequenceSb.append("v").append("=").append("1.0");
        sequenceSb.append(this.secret);
        String sequenceString = sequenceSb.toString();
        Log.trace(this, "Sequence String generated: " + sequenceString);
        String apiSig = MD5HashGenerator.generateMD5(sequenceString);
        return apiSig;
    }
}

