/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.http;

import com.sonyericsson.facebook.service.http.FacebookRequest;
import com.sonyericsson.facebook.service.xml.ListCommentParser;
import com.sonyericsson.facebook.utils.MD5HashGenerator;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.StringMap;
import com.sonyericsson.webalbum.util.StringUtil;
import java.io.UnsupportedEncodingException;

public class ListCommentRequest
extends FacebookRequest {
    private static final String GET_COMMENTS_METHOD = "facebook.photos.getComments";
    private String callId = this.getTime();
    private String sessionKey = null;
    private String secret = null;
    private String pid = null;

    public ListCommentRequest(ListCommentParser parser, String sessionKey, String secret, String pid) {
        super(parser);
        StringMap requestMap = null;
        String request = null;
        if (sessionKey != null && sessionKey.length() > 0 && secret != null && secret.length() > 0 && pid != null && pid.length() > 0) {
            this.sessionKey = sessionKey;
            this.secret = secret;
            this.pid = pid;
            requestMap = new StringMap();
            requestMap.put("method", GET_COMMENTS_METHOD);
            requestMap.put("api_key", "7a9abb81c85b92c5e02e427242652c24");
            requestMap.put("session_key", this.sessionKey);
            requestMap.put("call_id", this.callId);
            requestMap.put("pid", this.pid);
            requestMap.put("v", "1.0");
            requestMap.put("sig", this.getApiSig());
            try {
                request = StringUtil.encodeKeyValueString(requestMap, "&", null);
            }
            catch (UnsupportedEncodingException uee) {
                Log.error(this, "Unexpected UnsupportedEncodingException thrown when building request: " + uee.getMessage());
                throw new IllegalArgumentException("Error when trying to build the request");
            }
            if (request != null) {
                this.requestUrl = "https://api.facebook.com/restserver.php?" + request;
                Log.trace(this, "Request to send: " + request);
                try {
                    this.bodyBytes = request.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log.error(this, "UnsupportedEncodingException converting string to bytes (UTF-8): " + e.getMessage());
                    throw new IllegalArgumentException("UnsupportedEncodingException converting string to bytes (UTF-8)");
                }
                this.addHeader("Content-Type", "application/x-www-form-urlencoded");
                this.addHeader("Content-Length", String.valueOf(this.bodyBytes.length));
            }
        } else {
            Log.error(this, "Invalid parameters passed in constructor.");
            throw new IllegalArgumentException("Invalid parameters passed in constructor.");
        }
    }

    private String getApiSig() {
        StringBuffer sequenceSb = new StringBuffer();
        sequenceSb.append("api_key").append("=").append("7a9abb81c85b92c5e02e427242652c24");
        sequenceSb.append("call_id").append("=").append(this.callId);
        sequenceSb.append("method").append("=").append(GET_COMMENTS_METHOD);
        sequenceSb.append("pid").append("=").append(this.pid);
        sequenceSb.append("session_key").append("=").append(this.sessionKey);
        sequenceSb.append("v").append("=").append("1.0");
        sequenceSb.append(this.secret);
        String sequenceString = sequenceSb.toString();
        Log.trace(this, "Sequence String generated: " + sequenceString);
        String apiSig = MD5HashGenerator.generateMD5(sequenceString);
        return apiSig;
    }
}

