/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.http;

import com.sonyericsson.facebook.service.http.FacebookErrors;
import com.sonyericsson.facebook.service.http.FacebookRequest;
import com.sonyericsson.facebook.service.utils.ServiceUtils;
import com.sonyericsson.facebook.service.xml.UploadParser;
import com.sonyericsson.facebook.utils.MD5HashGenerator;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;

public class UploadPhotoRequest
extends FacebookRequest {
    private UploadParser parser;
    private String sessionKey;
    private String secret;
    private String fileUrl = null;
    public static final String FACEBOOK_UPLOAD_METHOD = "facebook.photos.upload";
    public static final String FACEBOOK_REST_API_URL = "http://api.facebook.com/restserver.php";
    private String boundary = MD5HashGenerator.generateMD5(this.getTime());
    private StringBuffer bodyPartSb = new StringBuffer();
    private StringBuffer closingPartSb = new StringBuffer();

    public UploadPhotoRequest(UploadParser parser, Content content, String secret, String sessionKey, String contentType) {
        super("POST", "http://api.facebook.com/restserver.php?facebook.photos.upload", new Hashtable(), 1024);
        String md5Sig;
        this.parser = parser;
        this.secret = secret;
        this.sessionKey = sessionKey;
        String aid = null;
        String caption = null;
        String fileName = null;
        String callId = this.getTime();
        Resource resource = content.getResource("content");
        String uploadFileUrl = resource.getLocalUrl();
        int lastBarPos = uploadFileUrl.lastIndexOf(47);
        if (lastBarPos >= 0) {
            fileName = uploadFileUrl.substring(lastBarPos + 1);
        }
        Log.trace("fileName: " + fileName);
        if (content.getAlbumId() != null) {
            aid = content.getAlbumId();
        }
        if (content.getDescription() != null) {
            caption = content.getDescription();
            caption = ServiceUtils.replaceParagraphChars(caption);
        }
        if (this.parser != null && this.sessionKey != null && this.sessionKey.length() > 0 && contentType != null && contentType.length() > 0 && this.secret != null && this.secret.length() > 0 && aid != null) {
            md5Sig = this.getApiSig(aid, callId, caption);
            this.fileUrl = uploadFileUrl;
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"method\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append(FACEBOOK_UPLOAD_METHOD).append("\r\n");
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"v\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append("1.0").append("\r\n");
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"api_key\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append("7a9abb81c85b92c5e02e427242652c24").append("\r\n");
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"session_key\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append(this.sessionKey).append("\r\n");
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"call_id\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append(callId).append("\r\n");
            if (caption != null) {
                this.bodyPartSb.append("--" + this.boundary).append("\r\n");
                this.bodyPartSb.append("Content-Disposition: form-data; name=\"caption\"").append("\r\n").append("\r\n");
                this.bodyPartSb.append(caption).append("\r\n");
            }
        } else {
            Log.error(this, "Invalid parameters passed in request constructor");
            throw new IllegalArgumentException("Invalid parameters passed in request constructor");
        }
        this.bodyPartSb.append("--" + this.boundary).append("\r\n");
        this.bodyPartSb.append("Content-Disposition: form-data; name=\"aid\"").append("\r\n").append("\r\n");
        this.bodyPartSb.append(aid).append("\r\n");
        this.bodyPartSb.append("--" + this.boundary).append("\r\n");
        this.bodyPartSb.append("Content-Disposition: form-data; name=\"sig\"").append("\r\n").append("\r\n");
        this.bodyPartSb.append(md5Sig).append("\r\n");
        this.bodyPartSb.append("--" + this.boundary).append("\r\n");
        this.bodyPartSb.append("Content-Disposition: form-data; filename=\"" + fileName + "\"").append("\r\n");
        this.bodyPartSb.append("Content-Type: " + contentType).append("\r\n");
        this.bodyPartSb.append("\r\n");
        this.closingPartSb.append("\r\n").append("--" + this.boundary + "--").append("\r\n");
        this.requestUrl = "http://api.facebook.com/restserver.php?facebook.photos.upload";
        Log.trace("requestUrl: " + this.requestUrl);
    }

    public int doRequest() {
        FileConnection fc;
        DataInputStream dIStrm;
        OutputStream os;
        HttpConnection conn;
        int result;
        block29: {
            String errorCode;
            InputStream is;
            block27: {
                result = 12;
                conn = null;
                os = null;
                is = null;
                long bytesToRead = 0L;
                long bodyBytesLenght = 0L;
                dIStrm = null;
                fc = null;
                errorCode = null;
                try {
                    fc = (FileConnection)Connector.open((String)this.fileUrl, (int)1);
                    dIStrm = fc.openDataInputStream();
                    bytesToRead = fc.fileSize();
                    Log.trace(this, "Size of file to be uploaded: " + bytesToRead);
                }
                catch (IOException ioEx) {
                    Log.trace("IOException when trying to open file: " + ioEx.getMessage());
                }
                bodyBytesLenght = (long)this.bodyPartSb.length() + bytesToRead + (long)this.closingPartSb.length();
                Log.trace(this, "Final content length: " + Long.toString(bodyBytesLenght));
                try {
                    conn = (HttpConnection)Connector.open((String)"http://api.facebook.com/restserver.php?method=facebook.photos.upload");
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("MIME-version", "1.0");
                    conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
                    conn.setRequestProperty("Content-Length", Long.toString(bodyBytesLenght));
                    conn.setRequestProperty("Connection", "close");
                    os = conn.openOutputStream();
                    if (os == null || dIStrm == null) {
                        throw new ServiceException(8);
                    }
                    Log.trace(this, "Writing body...");
                    os.write(this.bodyPartSb.toString().getBytes("UTF-8"));
                    this.copyStream(dIStrm, os);
                    if (!this.isCancelled()) {
                        os.write(this.closingPartSb.toString().getBytes());
                        Log.trace(this, "... done.");
                    }
                }
                catch (ServiceException se) {
                    Log.error(this, "ServiceException when opening connection to Facebook: " + se.getMessage());
                    result = se.getResult();
                    IOUtil.closeOutputStream(os);
                    if (this.isCancelled()) {
                        result = 1;
                    }
                    break block27;
                }
                catch (IOException connIoe) {
                    try {
                        Log.error(this, "IOException when opening connection to Facebook: " + connIoe.getMessage());
                        result = 8;
                        break block27;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtil.closeOutputStream(os);
                        if (this.isCancelled()) {
                            result = 1;
                        }
                    }
                }
                IOUtil.closeOutputStream(os);
                if (this.isCancelled()) {
                    result = 1;
                }
            }
            if (result != 8 && result != 1) {
                try {
                    try {
                        if (conn.getResponseCode() == 200) {
                            is = conn.openInputStream();
                            this.parser.parse(is);
                            result = 0;
                            errorCode = this.parser.getErrorCode();
                            if (!errorCode.trim().equalsIgnoreCase("")) {
                                result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.error(this, "Exception receiving response: " + e);
                        e.printStackTrace();
                        if (is != null) {
                            IOUtil.closeInputStream(is);
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        IOUtil.closeInputStream(is);
                    }
                    throw throwable;
                }
                if (is != null) {
                    IOUtil.closeInputStream(is);
                }
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException ioEx) {
                Log.error("Error closing connection: " + ioEx.getMessage());
                ioEx.printStackTrace();
            }
        }
        IOUtil.closeInputStream(dIStrm);
        IOUtil.closeConnection((Connection)fc);
        IOUtil.closeOutputStream(os);
        return result;
    }

    private String getApiSig(String aid, String callId, String caption) {
        StringBuffer bodySignature = new StringBuffer();
        String md5Sig = "";
        bodySignature.append("aid").append("=").append(aid);
        bodySignature.append("api_key").append("=").append("7a9abb81c85b92c5e02e427242652c24");
        bodySignature.append("call_id").append("=").append(callId);
        if (caption != null) {
            bodySignature.append("caption").append("=").append(caption);
        }
        bodySignature.append("method").append("=").append(FACEBOOK_UPLOAD_METHOD);
        bodySignature.append("session_key").append("=").append(this.sessionKey);
        bodySignature.append("v").append("=").append("1.0");
        bodySignature.append(this.secret);
        md5Sig = MD5HashGenerator.generateMD5(bodySignature.toString());
        return md5Sig;
    }
}

