/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.http;

import com.sonyericsson.facebook.service.http.FacebookErrors;
import com.sonyericsson.facebook.service.http.FacebookRequest;
import com.sonyericsson.facebook.service.xml.UploadParser;
import com.sonyericsson.facebook.utils.MD5HashGenerator;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;

public class UploadVideoRequest
extends FacebookRequest {
    private UploadParser parser;
    private String sessionKey;
    private String secret;
    private String fileUrl = null;
    public static final String FACEBOOK_UPLOAD_METHOD = "facebook.video.upload";
    public static final String FACEBOOK_VIDEO_UPLOAD_SERVER = "http://api-video.facebook.com/restserver.php";
    private String boundary = MD5HashGenerator.generateMD5(this.getTime());
    StringBuffer bodyPartSb = new StringBuffer();
    StringBuffer closingPartSb = new StringBuffer();

    public UploadVideoRequest(UploadParser parser, Content content, String secret, String sessionKey, String contentType) {
        super("POST", "http://api-video.facebook.com/restserver.php?facebook.video.upload", new Hashtable(), 1024);
        this.parser = parser;
        this.secret = secret;
        this.sessionKey = sessionKey;
        String title = null;
        String description = null;
        String fileName = null;
        String callId = this.getTime();
        Resource resource = content.getResource("content");
        String uploadFileUrl = resource.getLocalUrl();
        int lastBarPos = uploadFileUrl.lastIndexOf(47);
        if (lastBarPos >= 0) {
            fileName = uploadFileUrl.substring(lastBarPos + 1);
        }
        Log.trace("fileName: " + fileName);
        if (content.getTitle() != null) {
            title = content.getTitle();
        }
        if (content.getDescription() != null) {
            description = content.getDescription();
        }
        if (this.parser != null && this.sessionKey != null && this.sessionKey.length() > 0 && contentType != null && contentType.length() > 0 && this.secret != null && this.secret.length() > 0) {
            String md5Sig = this.getApiSig(callId, title, description);
            this.fileUrl = uploadFileUrl;
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"method\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append(FACEBOOK_UPLOAD_METHOD).append("\r\n");
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"v\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append("1.0").append("\r\n");
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"api_key\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append("7a9abb81c85b92c5e02e427242652c24").append("\r\n");
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"session_key\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append(this.sessionKey).append("\r\n");
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"call_id\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append(callId).append("\r\n");
            this.bodyPartSb.append("--" + this.boundary).append("\r\n");
            this.bodyPartSb.append("Content-Disposition: form-data; name=\"sig\"").append("\r\n").append("\r\n");
            this.bodyPartSb.append(md5Sig).append("\r\n");
            if (title != null) {
                this.bodyPartSb.append("--" + this.boundary).append("\r\n");
                this.bodyPartSb.append("Content-Disposition: form-data; name=\"title\"").append("\r\n").append("\r\n");
                this.bodyPartSb.append(title).append("\r\n");
            }
            if (description != null) {
                this.bodyPartSb.append("--" + this.boundary).append("\r\n");
                this.bodyPartSb.append("Content-Disposition: form-data; name=\"description\"").append("\r\n").append("\r\n");
                this.bodyPartSb.append(description).append("\r\n");
            }
        } else {
            Log.error(this, "Invalid parameters passed in request constructor");
            throw new IllegalArgumentException("Invalid parameters passed in request constructor");
        }
        this.bodyPartSb.append("--" + this.boundary).append("\r\n");
        this.bodyPartSb.append("Content-Disposition: form-data; filename=\"" + fileName + "\"").append("\r\n");
        this.bodyPartSb.append("Content-Type: " + contentType).append("\r\n");
        this.bodyPartSb.append("\r\n");
        this.closingPartSb.append("\r\n").append("--" + this.boundary + "--").append("\r\n");
        this.requestUrl = "http://api-video.facebook.com/restserver.php?facebook.video.upload";
        Log.trace("requestUrl: " + this.requestUrl);
    }

    public int doRequest() {
        FileConnection fc;
        DataInputStream dIStrm;
        OutputStream os;
        HttpConnection conn;
        int result;
        block35: {
            String errorCode;
            InputStream is;
            block33: {
                result = 12;
                conn = null;
                os = null;
                is = null;
                int bytesToRead = 0;
                int bodyBytesLenght = 0;
                dIStrm = null;
                fc = null;
                errorCode = null;
                try {
                    fc = (FileConnection)Connector.open((String)this.fileUrl, (int)1);
                    dIStrm = fc.openDataInputStream();
                    bytesToRead = dIStrm.available();
                }
                catch (IOException ioEx) {
                    Log.trace("IOException when trying to open file: " + ioEx.getMessage());
                    ioEx.printStackTrace();
                }
                bodyBytesLenght = this.bodyPartSb.length() + bytesToRead + this.closingPartSb.length();
                try {
                    try {
                        conn = (HttpConnection)Connector.open((String)"http://api-video.facebook.com/restserver.php?method=facebook.video.upload");
                        conn.setRequestMethod("POST");
                        conn.setRequestProperty("MIME-version", "1.0");
                        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
                        conn.setRequestProperty("Content-Length", Integer.toString(bodyBytesLenght));
                        os = conn.openOutputStream();
                        Log.trace(this, "Writing body...");
                        os.write(this.bodyPartSb.toString().getBytes("UTF-8"));
                        this.copyStream(dIStrm, os);
                        if (!this.isCancelled()) {
                            os.write(this.closingPartSb.toString().getBytes());
                            Log.trace(this, "... done.");
                        }
                    }
                    catch (IOException connIoe) {
                        Log.error(this, "IOException opening connection to Facebook: " + connIoe.getMessage());
                        result = 8;
                        try {
                            os.close();
                        }
                        catch (IOException ioe) {
                            Log.error(this, "IOException closing streams: " + ioe.getMessage());
                        }
                        if (this.isCancelled()) {
                            result = 1;
                        }
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        os.close();
                    }
                    catch (IOException ioe) {
                        Log.error(this, "IOException closing streams: " + ioe.getMessage());
                    }
                    if (this.isCancelled()) {
                        result = 1;
                    }
                    throw throwable;
                }
                try {
                    os.close();
                }
                catch (IOException ioe) {
                    Log.error(this, "IOException closing streams: " + ioe.getMessage());
                }
                if (this.isCancelled()) {
                    result = 1;
                }
            }
            if (result != 8 && result != 1) {
                try {
                    try {
                        if (conn.getResponseCode() == 200) {
                            is = conn.openInputStream();
                            this.parser.parse(is);
                            result = 0;
                            errorCode = this.parser.getErrorCode();
                            if (!errorCode.trim().equalsIgnoreCase("")) {
                                result = FacebookErrors.getWebAlbumErrorCode(errorCode);
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.error(this, "Exception receiving response: " + e.getMessage());
                        e.printStackTrace();
                        if (is != null) {
                            IOUtil.closeInputStream(is);
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        IOUtil.closeInputStream(is);
                    }
                    throw throwable;
                }
                if (is != null) {
                    IOUtil.closeInputStream(is);
                }
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException ioEx) {
                Log.error("Error closing connection: " + ioEx.getMessage());
                ioEx.printStackTrace();
            }
        }
        if (dIStrm != null) {
            IOUtil.closeInputStream(dIStrm);
        }
        if (fc != null) {
            IOUtil.closeConnection((Connection)fc);
        }
        if (os != null) {
            IOUtil.closeOutputStream(os);
        }
        return result;
    }

    private String getApiSig(String callId, String title, String description) {
        StringBuffer bodySignature = new StringBuffer();
        String md5Sig = "";
        bodySignature.append("api_key").append("=").append("7a9abb81c85b92c5e02e427242652c24");
        bodySignature.append("call_id").append("=").append(callId);
        if (description != null) {
            bodySignature.append("description").append("=").append(description);
        }
        bodySignature.append("method").append("=").append(FACEBOOK_UPLOAD_METHOD);
        bodySignature.append("session_key").append("=").append(this.sessionKey);
        if (title != null) {
            bodySignature.append("title").append("=").append(title);
        }
        bodySignature.append("v").append("=").append("1.0");
        bodySignature.append(this.secret);
        md5Sig = MD5HashGenerator.generateMD5(bodySignature.toString());
        return md5Sig;
    }
}

