/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.http;

import com.sonyericsson.facebook.service.http.FacebookRequest;
import com.sonyericsson.facebook.service.xml.UserInfoParser;
import com.sonyericsson.facebook.utils.MD5HashGenerator;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.StringMap;
import com.sonyericsson.webalbum.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class UserInfoRequest
extends FacebookRequest {
    private static final String USERS_GET_INFO_METHOD = "facebook.users.getinfo";
    private static final String REQUEST_DESIRED_FIELDS = "name,first_name,locale";
    private Vector uidsVector = null;
    private StringBuffer uidsSb = new StringBuffer();
    private String sessionKey = null;
    private String secret = null;
    private String callId = this.getTime();

    public UserInfoRequest(UserInfoParser parser, Vector uids, String sessionKey, String secret) {
        super(parser);
        StringMap requestMap = new StringMap();
        String request = null;
        if (uids != null && uids.size() > 0 && sessionKey != null && sessionKey.trim().length() > 0 && secret != null && secret.trim().length() > 0) {
            this.uidsVector = uids;
            this.sessionKey = sessionKey;
            this.secret = secret;
            int uidsVectorSize = this.uidsVector.size();
            this.uidsSb.append(uids.elementAt(0));
            int i = 1;
            while (i < uidsVectorSize) {
                this.uidsSb.append("," + uids.elementAt(i));
                ++i;
            }
            requestMap.put("api_key", "7a9abb81c85b92c5e02e427242652c24");
            requestMap.put("session_key", this.sessionKey);
            requestMap.put("call_id", this.callId);
            requestMap.put("v", "1.0");
            requestMap.put("method", USERS_GET_INFO_METHOD);
            requestMap.put("uids", this.uidsSb.toString());
            requestMap.put("fields", REQUEST_DESIRED_FIELDS);
            requestMap.put("sig", this.getApiSig());
            try {
                request = StringUtil.encodeKeyValueString(requestMap, "&", null);
            }
            catch (UnsupportedEncodingException uee) {
                Log.error(this, "Unexpected UnsupportedEncodingException thrown when building request: " + uee.getMessage());
                throw new IllegalArgumentException("Error trying to build the request");
            }
            if (request != null) {
                this.requestUrl = "https://api.facebook.com/restserver.php?" + request;
                Log.trace(this, "Get User Info request to send: " + this.requestUrl);
                try {
                    this.bodyBytes = request.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Log.error(this, "UnsupportedEncodingException converting string to bytes (UTF-8): " + e.getMessage());
                    throw new IllegalArgumentException("UnsupportedEncodingException converting string to bytes (UTF-8)");
                }
                this.addHeader("Content-Type", "application/x-www-form-urlencoded");
                this.addHeader("Content-Length", String.valueOf(this.bodyBytes.length));
            }
        } else {
            Log.error(this, "Invalid parameters passed in constructor.");
            throw new IllegalArgumentException("Invalid parameters passed in constructor.");
        }
    }

    private String getApiSig() {
        String md5ApiSig = "";
        StringBuffer inputMD5String = new StringBuffer();
        inputMD5String.append("api_key").append("=").append("7a9abb81c85b92c5e02e427242652c24");
        inputMD5String.append("call_id").append("=").append(this.callId);
        inputMD5String.append("fields").append("=").append(REQUEST_DESIRED_FIELDS);
        inputMD5String.append("method").append("=").append(USERS_GET_INFO_METHOD);
        inputMD5String.append("session_key").append("=").append(this.sessionKey);
        inputMD5String.append("uids").append("=").append(this.uidsSb.toString());
        inputMD5String.append("v").append("=").append("1.0");
        inputMD5String.append(this.secret);
        md5ApiSig = MD5HashGenerator.generateMD5(inputMD5String.toString());
        Log.trace(this, "Signature generated: " + md5ApiSig);
        return md5ApiSig;
    }
}

