/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.utils;

import com.sonyericsson.facebook.model.FacebookAlbum;
import com.sonyericsson.facebook.service.http.FacebookErrors;
import com.sonyericsson.facebook.service.http.FacebookHttpUtil;
import com.sonyericsson.facebook.service.http.ListAlbumRequest;
import com.sonyericsson.facebook.service.xml.ListAlbumParser;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.EntryList;
import com.sonyericsson.webalbum.service.ServiceException;
import java.util.Hashtable;

public class ServiceUtils {
    private static final Hashtable languageHash = new Hashtable();

    static {
        languageHash.put("pt_BR", "Fotos do perfil");
        languageHash.put("es_LA", "Fotos de perfil");
        languageHash.put("en_US", "Profile Pictures");
        languageHash.put("fr_FR", "Photos du profil");
        languageHash.put("de_DE", "Profilbilder");
        languageHash.put("ja_JP", "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u5199\u771f");
        languageHash.put("af_ZA", "Profielfoto\u2019s");
        languageHash.put("ar_AR", "\u0627\u0644\u0635\u0648\u0631 \u0627\u0644\u0634\u062e\u0635\u064a\u0629\u200f");
        languageHash.put("bg_BG", "\u0421\u043d\u0438\u043c\u043a\u0430 \u043d\u0430 \u043f\u0440\u043e\u0444\u0438\u043b\u0430");
        languageHash.put("ca_ES", "Imatges del perfil");
        languageHash.put("cs_CZ", "Profilov\u00e9 obr\u00e1zky");
        languageHash.put("cy_GB", "Lluniau Proffil");
        languageHash.put("da_DK", "Profilbilleder");
        languageHash.put("el_GR", "\u03a6\u03c9\u03c4\u03bf\u03b3\u03c1\u03b1\u03c6\u03af\u03b5\u03c2 \u03a0\u03c1\u03bf\u03c6\u03af\u03bb");
        languageHash.put("en_GB", "Profile Pictures");
        languageHash.put("en_PI", "Pirate Gallery");
        languageHash.put("es_ES", "Fotos de perfil");
        languageHash.put("eu_ES", "Profileko argazkiak");
        languageHash.put("fi_FI", "Profiilikuvat");
        languageHash.put("fr_CA", "Photos de profil");
        languageHash.put("gl_ES", "Fotos do Perfil");
        languageHash.put("he_IL", "\u05ea\u05de\u05d5\u05e0\u05d5\u05ea \u05e4\u05e8\u05d5\u05e4\u05d9\u05dc");
        languageHash.put("hr_HR", "Slike profila");
        languageHash.put("hu_HU", "Portr\u00e9k");
        languageHash.put("id_ID", "Foto Profil");
        languageHash.put("it_IT", "Immagini del profilo");
        languageHash.put("ko_KR", "\ud504\ub85c\ud544 \uc0ac\uc9c4");
        languageHash.put("lt_LT", "Portreto nuotraukos");
        languageHash.put("ms_MY", "Gambar Profil");
        languageHash.put("nb_NO", "Profilbilder");
        languageHash.put("nl_NL", "Profielfoto's");
        languageHash.put("nn_NO", "Profilbilete");
        languageHash.put("pl_PL", "album Zdj\u0119cia profilowe");
        languageHash.put("pt_PT", "Fotos do Perfil");
        languageHash.put("ro_RO", "Fotografii de profil");
        languageHash.put("ru_RU", "\u0424\u043e\u0442\u043e\u0433\u0440\u0430\u0444\u0438\u0438 \u043f\u0440\u043e\u0444\u0438\u043b\u044f");
        languageHash.put("sk_SK", "Fotky v profile");
        languageHash.put("sl_SI", "Prikazne slike");
        languageHash.put("sr_RS", "\u0421\u043b\u0438\u043a\u0435 \u043d\u0430 \u043f\u0440\u043e\u0444\u0438\u043b\u0443");
        languageHash.put("sv_SE", "Profilbilder");
        languageHash.put("th_TH", "\u0e23\u0e39\u0e1b\u0e02\u0e2d\u0e07\u0e04\u0e38\u0e13\u0e23\u0e39\u0e1b\u0e1b\u0e23\u0e30\u0e08\u0e33\u0e15\u0e31\u0e27 ");
        languageHash.put("tl_PH", "Mga Litrato sa Profile");
        languageHash.put("tr_TR", "Profil Resimleri");
        languageHash.put("vi_VN", "\u1ea2nh \u0110\u1ea1i Di\u1ec7n");
        languageHash.put("zh_CN", "\u4e2a\u4eba\u5934\u50cf ");
        languageHash.put("zh_HK", "\u500b\u4eba\u8cc7\u6599\u76f8\u7247 ");
        languageHash.put("zh_TW", "\u5927\u982d\u8cbc\u7167 ");
    }

    public static boolean isProfilePictures(FacebookAlbum albumEntry) {
        boolean isProfilePictures = false;
        String albumEntryUrl = "";
        String aidString = "aid=";
        String profilePictureId = "";
        int startIndex = -1;
        int endIndex = -1;
        if (albumEntry != null && (albumEntryUrl = albumEntry.getWebPageUrl()) != null && albumEntryUrl.length() > 0) {
            startIndex = albumEntryUrl.indexOf(aidString) + aidString.length();
            endIndex = albumEntryUrl.indexOf("&id");
            if (endIndex > startIndex && (profilePictureId = albumEntryUrl.substring(startIndex, endIndex)).equalsIgnoreCase("-3")) {
                isProfilePictures = true;
            }
        }
        return isProfilePictures;
    }

    public static boolean isProfilePictures(String albumId, String sessionKey, String secret) throws ServiceException {
        boolean isProfilePictures = false;
        int result = 12;
        EntryList albumList = null;
        ListAlbumParser getAlbumParser = new ListAlbumParser();
        ListAlbumRequest getAlbumReq = new ListAlbumRequest(getAlbumParser, sessionKey, secret, albumId);
        result = FacebookHttpUtil.doRequest(getAlbumReq, false);
        albumList = getAlbumParser.getEntries();
        String errorCode = getAlbumParser.getErrorCode();
        if (result == 0 && errorCode.trim().equalsIgnoreCase("")) {
            if (albumList != null) {
                Log.trace("Getting parsed entries.");
                Entry entry = albumList.getEntry(0);
                if (entry != null) {
                    FacebookAlbum albumEntry = (FacebookAlbum)entry;
                    isProfilePictures = ServiceUtils.isProfilePictures(albumEntry);
                }
            }
        } else {
            if (result == 0) {
                result = FacebookErrors.getWebAlbumErrorCode(errorCode);
            }
            throw new ServiceException(result);
        }
        return isProfilePictures;
    }

    public static String mapProfilePictureTitle(String locale) {
        String translatedTitle = "";
        translatedTitle = (String)languageHash.get(locale);
        return translatedTitle;
    }

    public static String replaceParagraphChars(String string) {
        Log.info("Passed string value: " + string);
        char[] crlf = new char[]{'\r', '\n'};
        StringBuffer captionSb = new StringBuffer(string);
        int paragraphIndex = string.indexOf(8233);
        while (paragraphIndex != -1) {
            captionSb.deleteCharAt(paragraphIndex);
            captionSb.insert(paragraphIndex, crlf);
            paragraphIndex = captionSb.toString().indexOf(8233);
        }
        string = captionSb.toString();
        Log.info("Resultant string value after changes: " + string);
        return string;
    }

    public static String EscapeCharacter(String s) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '&': {
                    sbuf.append("%26");
                    break;
                }
                case '+': {
                    sbuf.append("%2B");
                    break;
                }
                default: {
                    sbuf.append(ch);
                }
            }
            ++i;
        }
        return sbuf.toString();
    }
}

