/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.xml;

import com.sonyericsson.facebook.model.FacebookAlbum;
import com.sonyericsson.facebook.service.xml.FacebookParser;
import com.sonyericsson.webalbum.model.EntryList;
import java.util.Vector;
import org.xml.sax.Attributes;

public class ListAlbumParser
extends FacebookParser {
    private static final String ALBUM_PATH = "/photos_getAlbums_response/album";
    protected FacebookAlbum currentAlbum;
    private int numberOfAlbums = 0;
    private int albumNumber = 0;
    private Vector albumVector = new Vector();
    private Vector pidsVector = new Vector();

    public void startElement(String element, Attributes attributes) {
        super.startElement(element, attributes);
        if (this.isCurrentPath(ALBUM_PATH)) {
            this.currentAlbum = new FacebookAlbum();
            ++this.albumNumber;
        }
    }

    protected void characters(String element, char[] ch, int start, int length) {
        super.characters(element, ch, start, length);
        if (this.isCurrentPath("/photos_getAlbums_response/album/aid")) {
            this.currentAlbum.setId(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_getAlbums_response/album/cover_pid")) {
            this.currentAlbum.setCoverPhotoId(new String(ch, start, length));
            this.pidsVector.addElement(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_getAlbums_response/album/owner")) {
            this.currentAlbum.setOwner(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_getAlbums_response/album/name")) {
            String albumName = new String(ch, start, length);
            if (albumName.length() > 65) {
                albumName = albumName.substring(0, 65);
            }
            this.currentAlbum.setTitle(albumName);
        } else if (this.isCurrentPath("/photos_getAlbums_response/album/created")) {
            this.currentAlbum.setCreated(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_getAlbums_response/album/modified")) {
            this.currentAlbum.setTimestamp(Long.parseLong(new String(ch, start, length)));
        } else if (this.isCurrentPath("/photos_getAlbums_response/album/description")) {
            String albumDescription = new String(ch, start, length);
            if (albumDescription.length() > 4096) {
                albumDescription = albumDescription.substring(0, 4096);
            }
            this.currentAlbum.setDescription(albumDescription);
        } else if (this.isCurrentPath("/photos_getAlbums_response/album/location")) {
            this.currentAlbum.setLocation(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_getAlbums_response/album/link")) {
            this.currentAlbum.setWebPageUrl(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_getAlbums_response/album/size")) {
            this.currentAlbum.setNumberOfPhotos(Integer.parseInt(new String(ch, start, length)));
        } else if (this.isCurrentPath("/photos_getAlbums_response/album/visible")) {
            this.currentAlbum.setVisible(this.mapPermission(new String(ch, start, length)));
        }
    }

    public final void endElement(String element) {
        boolean isAlbumProfilePictures = false;
        String currentAlbumTitle = null;
        if (element.equals("album") && this.currentAlbum != null) {
            currentAlbumTitle = this.currentAlbum.getTitle();
            if (currentAlbumTitle != null) {
                boolean bl = isAlbumProfilePictures = this.albumNumber == 1 && currentAlbumTitle.equals("Profile Pictures");
            }
            if (this.albumNumber > 1 && !isAlbumProfilePictures) {
                this.albumVector.addElement(this.currentAlbum);
                ++this.numberOfAlbums;
                this.currentAlbum = null;
            }
        }
    }

    public EntryList getEntries() {
        return new EntryList(this.numberOfAlbums, 0, this.albumVector);
    }

    public Vector getPidsVector() {
        return this.pidsVector;
    }
}

