/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.xml;

import com.sonyericsson.facebook.model.FacebookComment;
import com.sonyericsson.facebook.service.xml.FacebookParser;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.EntryList;
import java.util.Vector;
import org.xml.sax.Attributes;

public class ListCommentParser
extends FacebookParser {
    private static final String COMMENT_PATH = "/photos_getComments_response/photo_comment";
    private FacebookComment currentComment;
    private int numberOfComments = 0;
    private Vector commentVector = new Vector();

    public void startElement(String element, Attributes attributes) {
        super.startElement(element, attributes);
        if (this.isCurrentPath(COMMENT_PATH)) {
            this.currentComment = new FacebookComment();
        }
    }

    protected void characters(String element, char[] ch, int start, int length) {
        super.characters(element, ch, start, length);
        if (this.isCurrentPath("/photos_getComments_response/photo_comment/pid")) {
            this.currentComment.setContentId(new String(ch, start, length));
        }
        if (this.isCurrentPath("/photos_getComments_response/photo_comment/from")) {
            this.currentComment.setAuthorId(new String(ch, start, length));
        }
        if (this.isCurrentPath("/photos_getComments_response/photo_comment/body")) {
            String commentText = new String(ch, start, length);
            if (commentText.length() > 1000) {
                commentText = commentText.substring(0, 1000);
            }
            this.currentComment.setText(commentText);
        }
        if (this.isCurrentPath("/photos_getComments_response/photo_comment/time")) {
            try {
                long timestamp = Long.parseLong(new String(ch, start, length));
                this.currentComment.setTimestamp(timestamp * 1000L);
            }
            catch (NumberFormatException nfe) {
                Log.error("NumberFormatException parsing comment timestamp: " + nfe);
            }
        }
    }

    public final void endElement(String element) {
        if (this.currentComment != null && element.equals("photo_comment")) {
            this.commentVector.addElement(this.currentComment);
            ++this.numberOfComments;
            this.currentComment = null;
        }
    }

    public EntryList getEntries() {
        return new EntryList(this.numberOfComments, 0, this.commentVector);
    }
}

