/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.xml;

import com.sonyericsson.facebook.model.FacebookContent;
import com.sonyericsson.facebook.service.xml.FacebookParser;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.EntryList;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;

public class ListContentParser
extends FacebookParser {
    private static final String CONTENT_PATH = "/photos_get_response/photo";
    protected FacebookContent currentContent;
    private int numberOfContents = 0;
    private Vector contentVector = new Vector();
    private Hashtable pidThumbUrlMap = new Hashtable();

    public void startElement(String element, Attributes attributes) {
        super.startElement(element, attributes);
        if (this.isCurrentPath(CONTENT_PATH)) {
            this.currentContent = new FacebookContent();
        }
    }

    protected void characters(String element, char[] ch, int start, int length) {
        super.characters(element, ch, start, length);
        if (this.isCurrentPath("/photos_get_response/photo/pid")) {
            this.currentContent.setId(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_get_response/photo/aid")) {
            this.currentContent.setAlbumId(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_get_response/photo/owner")) {
            this.currentContent.setOwner(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_get_response/photo/src")) {
            this.currentContent.setSrc(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_get_response/photo/src_big")) {
            this.currentContent.setSrcBig(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_get_response/photo/src_small")) {
            this.currentContent.setSrcSmall(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_get_response/photo/link")) {
            this.currentContent.setWebPageUrl(new String(ch, start, length));
        } else if (this.isCurrentPath("/photos_get_response/photo/caption")) {
            String description = new String(ch, start, length);
            if (description.length() > 4096) {
                description = description.substring(0, 4096);
            }
            this.currentContent.setDescription(description);
        } else if (this.isCurrentPath("/photos_get_response/photo/created")) {
            this.currentContent.setCreated(new String(ch, start, length));
            try {
                this.currentContent.setTimestamp(Long.parseLong(new String(ch, start, length)));
            }
            catch (NumberFormatException nfe) {
                Log.error("NumberFormatException parsing returned Time Stamp: " + nfe);
            }
        }
    }

    public final void endElement(String element) {
        if (this.currentContent != null && element.equals("photo")) {
            this.contentVector.addElement(this.currentContent);
            this.pidThumbUrlMap.put(this.currentContent.getId(), this.currentContent.getSrcSmall());
            ++this.numberOfContents;
            this.currentContent = null;
        }
    }

    public EntryList getEntries() {
        return new EntryList(this.numberOfContents, 0, this.contentVector);
    }

    public String getPidThumbUrl(String contentId) {
        return (String)this.pidThumbUrlMap.get(contentId);
    }
}

