/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.service.xml;

import com.sonyericsson.facebook.service.xml.FacebookParser;
import java.util.Hashtable;
import org.xml.sax.Attributes;

public class UserInfoParser
extends FacebookParser {
    public static final int USER_NAME_INDEX = 0;
    public static final int NICKNAME_INDEX = 1;
    private static final String USER_PATH = "/users_getinfo_response/user";
    private static final String UID_PATH = "/users_getinfo_response/user/uid";
    private static final String USER_NAME_PATH = "/users_getinfo_response/user/name";
    private static final String NICKNAME_NAME_PATH = "/users_getinfo_response/user/first_name";
    private static final String USER_LOCALE_PATH = "/users_getinfo_response/user/locale";
    private String currentUserName = null;
    private String userLocale = null;
    private String currentUserNickName = null;
    private String currentOwner = null;
    private String[] nameNickStrings = null;
    private Hashtable ownerDataHash = new Hashtable();

    public void startElement(String element, Attributes attributes) {
        super.startElement(element, attributes);
        if (this.isCurrentPath(USER_PATH)) {
            this.nameNickStrings = new String[2];
        }
    }

    protected void characters(String element, char[] ch, int start, int length) {
        super.characters(element, ch, start, length);
        if (this.isCurrentPath(UID_PATH) && this.nameNickStrings != null) {
            this.currentOwner = new String(ch, start, length);
        }
        if (this.isCurrentPath(USER_NAME_PATH) && this.nameNickStrings != null) {
            this.currentUserName = new String(ch, start, length);
            this.nameNickStrings[0] = new String(ch, start, length);
        }
        if (this.isCurrentPath(NICKNAME_NAME_PATH) && this.nameNickStrings != null) {
            this.currentUserNickName = new String(ch, start, length);
            this.nameNickStrings[1] = new String(ch, start, length);
        }
        if (this.isCurrentPath(USER_LOCALE_PATH)) {
            this.userLocale = new String(ch, start, length);
        }
    }

    public final void endElement(String element) {
        if (this.nameNickStrings != null && this.nameNickStrings.length == 2 && this.nameNickStrings[0] != null && this.nameNickStrings[1] != null && this.currentOwner != null && element.equals("user")) {
            this.ownerDataHash.put(this.currentOwner, this.nameNickStrings);
        }
    }

    public String getUserName() {
        return this.currentUserName;
    }

    public String getNickName() {
        return this.currentUserNickName;
    }

    public String[] getOwnerData(String ownerId) {
        return (String[])this.ownerDataHash.get(ownerId);
    }

    public String getLocale() {
        return this.userLocale;
    }
}

