/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.facebook.utils;

import com.sonyericsson.webalbum.codec.AttributeCodec;
import com.sonyericsson.webalbum.log.Log;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5HashGenerator {
    public static String generateMD5(String inputString) {
        String md5HashString = null;
        int outputLength = 0;
        AttributeCodec attrCodec = new AttributeCodec();
        if (inputString != null) {
            inputString = attrCodec.decode(inputString);
            try {
                byte[] byteArrayInput = inputString.getBytes("UTF-8");
                byte[] byteArrayOutput = new byte[16];
                StringBuffer strbuf = new StringBuffer();
                MessageDigest msgdigest = MessageDigest.getInstance("MD5");
                msgdigest.update(byteArrayInput, 0, byteArrayInput.length);
                outputLength = msgdigest.digest(byteArrayOutput, 0, byteArrayOutput.length);
                int i = 0;
                while (i < outputLength) {
                    strbuf.append(Integer.toHexString(256 + (byteArrayOutput[i] & 0xFF)).substring(1));
                    ++i;
                }
                md5HashString = strbuf.toString();
            }
            catch (UnsupportedEncodingException uee) {
                Log.trace("UnsupportedEncondingException trying to generate MD5 hash: " + uee.getMessage());
            }
            catch (NoSuchAlgorithmException nsae) {
                Log.trace("NoSuchAlgorithmException trying to generate MD5 hash: " + nsae.getMessage());
            }
            catch (DigestException de) {
                Log.error("DigestException trying to generate MD5 hash: " + de.getMessage());
            }
        }
        return md5HashString;
    }
}

