/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.http;

import com.sonyericsson.webalbum.http.ConnectionFactory;
import com.sonyericsson.webalbum.http.DefaultConnectionFactory;
import com.sonyericsson.webalbum.http.HttpConnection_1_0;
import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.HttpsConnection;

public abstract class HttpUtil {
    public static final int PROTOCOL_VERSION_1_0 = 0;
    public static final int PROTOCOL_VERSION_1_1 = 1;
    private static ConnectionFactory connectionFactory = new DefaultConnectionFactory();

    private static void setPrioritisedRequestHeader(HttpConnection conn, Hashtable headers, String property) throws IOException {
        String value = (String)headers.remove(property);
        if (value != null) {
            Log.trace("HttpUtil#setPrioritisedRequestHeader: '" + property + ": " + value + "'");
            conn.setRequestProperty(property, value);
        }
    }

    private static void setRequestHeaders(HttpConnection conn, HttpRequest request) throws IOException {
        Hashtable headers = request.getHeaders();
        if (headers != null) {
            Enumeration keys = headers.keys();
            try {
                HttpUtil.setPrioritisedRequestHeader(conn, headers, "Content-Type");
                HttpUtil.setPrioritisedRequestHeader(conn, headers, "Content-Length");
                HttpUtil.setPrioritisedRequestHeader(conn, headers, "MIME-Version");
            }
            catch (Exception e) {
                Log.error("Exception setting request headers: " + e);
            }
            while (keys.hasMoreElements()) {
                String property = (String)keys.nextElement();
                String value = (String)headers.get(property);
                Log.trace("HttpUtil#setRequestHeaders: '" + property + ": " + value + "'");
                conn.setRequestProperty(property, value);
            }
        }
    }

    private static void writeBody(HttpConnection conn, HttpRequest request) throws IOException {
        OutputStream os = null;
        try {
            Log.trace("HttpUtil#writeBody : opening OutputStream");
            os = conn.openOutputStream();
            Log.trace("HttpUtil#writeBody : writing body");
            request.writeBody(os);
            Log.trace("HttpUtil#writeBody : body written");
        }
        finally {
            if (os != null) {
                try {
                    Log.trace("HttpUtil#writeBody : closing OutputStream");
                    os.close();
                }
                catch (IOException e) {
                    Log.logException(e);
                }
            }
        }
        Log.trace("HttpUtil#writeBody : done");
    }

    private static void readResponseBody(HttpConnection conn, HttpRequest request) throws IOException {
        InputStream is = null;
        try {
            is = conn.openInputStream();
            request.readResponseBody(is);
        }
        finally {
            IOUtil.closeInputStream(is);
        }
    }

    private static boolean doRequest(HttpRequest request, boolean useOverrideMethod, int protocolVersion) throws IOException {
        HttpConnection_1_0 conn = null;
        try {
            try {
                Log.trace("HttpUtil#doRequest: opening connection to " + request.getURL());
                if (protocolVersion == 0) {
                    Log.trace("HttpUtil#doRequest using HttpConnection_1_0");
                    conn = HttpConnection_1_0.open(request.getURL());
                } else if (request.getURL().startsWith("https")) {
                    Log.trace("HttpUtil#doRequest using HTTPS connection");
                    conn = (HttpsConnection)connectionFactory.open(request.getURL());
                } else {
                    Log.trace("HttpUtil#doRequest using standard connection");
                    conn = (HttpConnection)connectionFactory.open(request.getURL());
                }
                String method = request.getMethod();
                if (!useOverrideMethod) {
                    Log.trace("HttpUtil#doRequest: setting request method " + method);
                    try {
                        conn.setRequestMethod(method);
                    }
                    catch (IOException e) {
                        Log.warning("HttpUtil#doRequest: request method not supported");
                        useOverrideMethod = true;
                    }
                }
                if (useOverrideMethod) {
                    Log.trace("HttpUtil#doRequest: using X-HTTP-Method-Override, setting request method POST");
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("X-HTTP-Method-Override", method);
                    conn.setRequestProperty("Content-Length", "0");
                }
                Log.trace("HttpUtil#doRequest: setting request headers");
                HttpUtil.setRequestHeaders(conn, request);
                if (method.equals("POST") || method.equals("PUT")) {
                    Log.trace("HttpUtil#doRequest: writing body");
                    HttpUtil.writeBody(conn, request);
                }
                Log.trace("HttpUtil#doRequest: handling response");
                request.setResponse(conn.getResponseCode(), conn.getResponseMessage());
                try {
                    request.setContentLength(Integer.parseInt(conn.getHeaderField("Content-Length")));
                    Log.trace("HttpUtil#doRequest: Content-Length is " + request.getResponseContentLength());
                }
                catch (RuntimeException re) {
                    Log.warning("HttpUtil#doRequest: Could not get Content-length header");
                }
                Log.trace("HttpUtil#doRequest: reading response body");
                HttpUtil.readResponseBody(conn, request);
                Log.trace("HttpUtil#doRequest: complete");
            }
            catch (IOException e) {
                Log.logException(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeConnection(conn);
            throw throwable;
        }
        IOUtil.closeConnection((Connection)conn);
        return useOverrideMethod;
    }

    public static void setConnectionFactory(ConnectionFactory factory) {
        connectionFactory = factory;
    }

    public static void doRequest(HttpRequest request, int protocolVersion) throws IOException {
        boolean usedOverrideMethod = HttpUtil.doRequest(request, false, protocolVersion);
        int responseCode = request.getResponseCode();
        String method = request.getMethod();
        if (!usedOverrideMethod && responseCode == 400 && (method.equals("DELETE") || method.equals("PUT"))) {
            Log.warning("HttpUtil#doRequest: HTTP request failed, possibly due to method " + method + " not being supported, retrying with X-HTTP-Method-Override.");
            HttpUtil.doRequest(request, true, protocolVersion);
        }
    }

    public static void doRequest(HttpRequest request) throws IOException {
        HttpUtil.doRequest(request, 1);
    }
}

