/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.invocation;

import com.sonyericsson.content.ContentHandlerProgress;
import com.sonyericsson.webalbum.invocation.InvocationListener;
import com.sonyericsson.webalbum.log.Log;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Invocation;

public final class InvocationHandler
implements Runnable {
    private static final int STATE_NONE = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_STOPPED = 2;
    private static final int STATE_EXPIRED = 3;
    private int state = 0;
    private ContentHandlerServer handler;
    private long timeout;
    private InvocationListener listener;
    private int pendingRequests;
    private Timer timer;

    private synchronized void updateInactivityTimer() {
        if (this.getState() == 1 && this.pendingRequests == 0 && this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    InvocationHandler invocationHandler = InvocationHandler.this;
                    synchronized (invocationHandler) {
                        if (InvocationHandler.this.pendingRequests == 0) {
                            Log.info("InvocationHandler: Inactivity!");
                            InvocationHandler.this.setState(3);
                            InvocationHandler.this.handler.cancelGetRequest();
                            InvocationHandler.this.listener.inactivityNotify();
                        }
                    }
                }
            }, this.timeout);
            Log.trace("InvocationHandler: Setting timer of " + this.timeout + " seconds");
        } else if (this.pendingRequests > 0 && this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            Log.trace("InvocationHandler: Cancelling timer");
        }
    }

    public InvocationHandler(ContentHandlerServer handler, long timeout) {
        this.handler = handler;
        this.timeout = timeout;
    }

    public synchronized void start() {
        if (this.getState() == 0) {
            this.setState(1);
            new Thread((Runnable)this, "InvocationHandler").start();
        }
    }

    public synchronized void stop() {
        this.setState(2);
        this.handler.cancelGetRequest();
    }

    public void setInvocationListener(InvocationListener listener) {
        this.listener = listener;
    }

    public synchronized void reportInvocationProgress(Invocation invocation) {
        if (this.pendingRequests > 0) {
            Log.trace("InvocationHandler: Sending progress for request '" + invocation.getAction() + "'");
            Log.logInvocation("[prog]", invocation);
            try {
                ContentHandlerProgress.reportProgress((ContentHandlerServer)this.handler, (Invocation)invocation);
                Log.trace("InvocationHandler: Progress sent");
            }
            catch (Exception e) {
                Log.logException(e);
            }
        }
    }

    public synchronized void finishInvocation(Invocation invocation, int status) {
        if (this.pendingRequests > 0) {
            Log.trace("InvocationHandler: Finishing request '" + invocation.getAction() + "'");
            Log.logInvocation("[out] ", invocation, status);
            this.handler.finish(invocation, status);
            --this.pendingRequests;
            this.updateInactivityTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.updateInactivityTimer();
        while (this.getState() == 1) {
            Invocation invocation = this.handler.getRequest(true);
            if (invocation == null) continue;
            Log.trace("InvocationHandler: Got request '" + invocation.getAction() + "'");
            Log.logInvocation("[in]  ", invocation);
            InvocationHandler invocationHandler = this;
            synchronized (invocationHandler) {
                ++this.pendingRequests;
                this.updateInactivityTimer();
            }
            this.listener.invocationRequestNotify(invocation);
        }
        Log.trace("InvocationHandler#run: Exiting");
    }

    private synchronized int getState() {
        return this.state;
    }

    private synchronized void setState(int state) {
        this.state = state;
    }
}

