/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.service.transfer;

import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.TransferItemCodec;
import com.sonyericsson.webalbum.model.TransferItem;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.transfer.TransferJobListener;

public class TransferJobResponseHandler
implements TransferJobListener {
    private Action action;
    private ActionResponseListener responseListener;

    public TransferJobResponseHandler(Action action, ActionResponseListener responseListener) {
        this.action = action;
        this.responseListener = responseListener;
    }

    private void encodeTransferItems(TransferItem[] items) {
        int i = 0;
        while (i < items.length) {
            ActionData childData = this.action.getChildData(i);
            this.encodeTransferItem(items[i], childData);
            ++i;
        }
    }

    protected void encodeTransferItem(TransferItem item, ActionData childData) {
        Attributes childOutAttr = TransferItemCodec.encodeTransferItem(item);
        childData.setAttributes(childOutAttr);
    }

    public void transferProgressNotify(int transferId, TransferItem[] items) {
        this.encodeTransferItems(items);
        this.responseListener.actionProgressNotify(this.action);
    }

    public void transferCompleteNotify(int transferId, TransferItem[] items, int result) {
        Attributes mainOutAttr = new Attributes();
        mainOutAttr.set("result", Result.toString(result));
        mainOutAttr.set("transfer:id", String.valueOf(transferId));
        this.action.getMainData().setAttributes(mainOutAttr);
        this.encodeTransferItems(items);
        this.responseListener.actionCompleteNotify(this.action);
    }
}

