/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.util;

import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.imageeffect.ImageTransformControl;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.MediaException;

public abstract class MediaUtil {
    static /* synthetic */ Class class$0;

    public static boolean resizeImage(String sourceUrl, String contentType, int maxWidthOrHeight, String targetUrl) throws IOException, MediaException {
        boolean resized = false;
        FileConnection ifc = null;
        InputStream is = null;
        FileConnection ofc = null;
        OutputStream os = null;
        try {
            ifc = (FileConnection)Connector.open((String)sourceUrl, (int)1);
            is = ifc.openInputStream();
            MediaProcessor mp = GlobalManager.createMediaProcessor((String)contentType);
            mp.setInput(is, -1);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.microedition.amms.control.imageeffect.ImageTransformControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ImageTransformControl transform = (ImageTransformControl)mp.getControl(clazz.getName());
            int sourceWidth = transform.getSourceWidth();
            int sourceHeight = transform.getSourceHeight();
            double shrinkFactor = (double)Math.max(sourceWidth, sourceHeight) / (double)maxWidthOrHeight;
            Log.info("MediaUtil#resizePhoto: sourceWidth = " + sourceWidth);
            Log.info("MediaUtil#resizePhoto: sourceHeight = " + sourceHeight);
            Log.info("MediaUtil#resizePhoto: shrinkFactor = " + shrinkFactor);
            if (shrinkFactor > 1.0) {
                int targetWidth = (int)((double)sourceWidth / shrinkFactor);
                int targetHeight = (int)((double)sourceHeight / shrinkFactor);
                Log.info("MediaUtil#resizePhoto: targetWidth = " + targetWidth);
                Log.info("MediaUtil#resizePhoto: targetHeight = " + targetHeight);
                transform.setTargetSize(targetWidth, targetHeight, 0);
                transform.setEnabled(true);
                ofc = (FileConnection)Connector.open((String)targetUrl);
                if (ofc.exists()) {
                    ofc.delete();
                }
                ofc.create();
                os = ofc.openOutputStream();
                mp.setOutput(os);
                mp.complete();
                Log.info("MediaUtil#resizePhoto: Resized to " + targetWidth + "x" + targetHeight);
                resized = true;
            }
        }
        finally {
            IOUtil.closeOutputStream(os);
            IOUtil.closeConnection(ofc);
            IOUtil.closeInputStream(is);
            IOUtil.closeConnection((Connection)ifc);
        }
        return resized;
    }
}

