/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.action;

import com.nokia.mid.iapinfo.AccessPoint;
import com.nokia.mid.iapinfo.IAPInfo;
import com.nokia.mid.iapinfo.IAPInfoException;
import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.http.HttpUtil;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.CacheUtil;
import com.sonyericsson.youtube.service.http.YouTubeRequest;
import java.io.IOException;
import java.io.InputStream;

public abstract class ActionUtil {
    static /* synthetic */ Class class$0;

    public static void doHttpRequest(HttpRequest request) throws ServiceException {
        int result = 12;
        try {
            HttpUtil.doRequest(request);
            result = ActionUtil.resultFromHttpResponseCode(request.getResponseCode());
        }
        catch (IOException e) {
            result = 8;
        }
        if (result != 0) {
            throw new ServiceException(result);
        }
    }

    public static void doHttpRequest(YouTubeRequest request, boolean isRefreshForced) throws ServiceException {
        String cacheUrl;
        int result = 12;
        boolean doHttpRequest = true;
        if (!isRefreshForced && CacheUtil.cachedFileIsValid(cacheUrl = CacheUtil.getCachedFileUrl(request.getRequestUrl()))) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.youtube.service.action.ActionUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.trace(clazz, "Returning cached version of the response");
            try {
                InputStream cachedFileIs = CacheUtil.openCachedFile(cacheUrl).openInputStream();
                request.parseResponse(cachedFileIs);
                result = 0;
                doHttpRequest = false;
            }
            catch (IOException ioe) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("com.sonyericsson.youtube.service.action.ActionUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(clazz2, "IOException reading cached response: " + ioe.getMessage());
            }
        }
        if (doHttpRequest) {
            try {
                HttpUtil.doRequest(request);
                result = ActionUtil.resultFromHttpResponseCode(request.getResponseCode());
            }
            catch (IOException e) {
                result = 8;
            }
        }
        if (result != 0) {
            throw new ServiceException(result);
        }
    }

    public static int resultFromHttpResponseCode(int responseCode) {
        int result = 12;
        switch (responseCode) {
            case 200: 
            case 201: {
                result = 0;
                break;
            }
            case 401: 
            case 403: {
                result = 5;
                break;
            }
            case 400: 
            case 404: {
                result = 2;
                break;
            }
            case 503: {
                result = 6;
                break;
            }
            case 500: {
                result = 7;
                break;
            }
            default: {
                result = 12;
            }
        }
        return result;
    }

    public static String getAPIdUrl(String accessPointId, String url) throws ServiceException {
        String requestUrl = url;
        IAPInfo iapInfo = null;
        AccessPoint accessPoint = null;
        if (accessPointId != null && accessPointId.length() > 0) {
            try {
                Log.trace("Using preferred access point to perform request");
                int apId = Integer.parseInt(accessPointId);
                iapInfo = IAPInfo.getIAPInfo();
                if (iapInfo != null) {
                    accessPoint = iapInfo.getAccessPoint(apId);
                    if (accessPoint == null) {
                        Log.error("Error getting access point");
                        throw new ServiceException(8);
                    }
                } else {
                    Log.error("Error getting IAP info");
                    throw new ServiceException(8);
                }
                requestUrl = accessPoint.getURL(url);
                Log.trace("Request URL: " + requestUrl);
            }
            catch (IAPInfoException iapEx) {
                Log.error("IAPInfoException getting access point: " + iapEx.getMessage());
                throw new ServiceException(8);
            }
            catch (NumberFormatException nfe) {
                Log.trace("NumberFormatException thrown parsing access point ID to integer.");
                throw new ServiceException(2);
            }
        } else {
            Log.trace("Using default access point to perform request.");
        }
        return requestUrl;
    }
}

