/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.action;

import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.CapabilityCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Capability;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;

public class CapabilitiesActionHandler
implements ActionHandler {
    private static final int TITLE_MAX_LEN = 60;

    public void handleAction(Action action, ActionResponseListener responseListener) {
        Attributes outAttr;
        ActionData actionData;
        int result;
        block6: {
            result = 0;
            Capability capability = null;
            actionData = action.getMainData();
            Attributes inAttr = actionData.getAttributes();
            String type = inAttr.get("item:type");
            outAttr = new Attributes();
            outAttr.set("item:type", type);
            try {
                if (type == null) {
                    throw new ServiceException(4);
                }
                if (type.equals("item")) {
                    capability = new Capability("item:type", true);
                    capability.addAllowedValue("item");
                    capability.addAllowedValue("entry");
                    capability.addAllowedValue("credentials");
                    capability.addAllowedValue("content");
                    this.addCapability(outAttr, capability);
                    break block6;
                }
                if (type.equals("credentials")) {
                    this.addCapability(outAttr, new Capability("user:login", true));
                    this.addCapability(outAttr, new Capability("user:password", true));
                    break block6;
                }
                if (type.equals("content")) {
                    this.addCapability(outAttr, new Capability("content:title", true, 60));
                    this.addCapability(outAttr, new Capability("content:description", true, 4096));
                    this.addCapability(outAttr, new Capability("content:keywords", true, 25));
                    capability = new Capability("content:access", true);
                    capability.addAllowedValue("public");
                    capability.addAllowedValue("private");
                    this.addCapability(outAttr, capability);
                    break block6;
                }
                throw new ServiceException(3);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing Capabilities Action Handler: " + se.getMessage());
                result = se.getResult();
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }

    public void addCapability(Attributes attrib, Capability capab) {
        String value = CapabilityCodec.encodeCapability(capab);
        attrib.set("capability:" + capab.getName(), value);
    }
}

