/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.action;

import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.youtube.model.YouTubeContent;
import com.sonyericsson.youtube.service.action.ActionUtil;
import com.sonyericsson.youtube.service.http.AuthenticationUtils;
import com.sonyericsson.youtube.service.http.YouTubeRequest;
import com.sonyericsson.youtube.service.xml.GetVideoInfoParser;
import com.sonyericsson.youtube.utils.RMSStorage;

public class GetActionHandler
implements ActionHandler {
    public void handleAction(Action action, ActionResponseListener responseListener) {
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        String type = inAttr.get("item:type");
        Attributes outAttr = new Attributes();
        if (type == null) {
            outAttr.set("result", Result.toString(4), 0);
            actionData.setAttributes(outAttr);
        } else if (type.equalsIgnoreCase("content")) {
            this.handleGetContentRequest(action);
        } else {
            outAttr.set("result", Result.toString(3), 0);
            actionData.setAttributes(outAttr);
        }
        responseListener.actionCompleteNotify(action);
    }

    private void handleGetContentRequest(Action getContentAction) {
        int result = 12;
        Attributes outAttr = new Attributes();
        YouTubeContent content = new YouTubeContent();
        GetVideoInfoParser parser = null;
        YouTubeRequest request = null;
        String videoId = null;
        String userId = null;
        String token = null;
        String url = null;
        RMSStorage rmsStorage = null;
        try {
            rmsStorage = RMSStorage.getRMSStorage();
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing get action handler: " + se.getMessage());
            result = se.getResult();
            outAttr.set("result", Result.toString(result), 0);
        }
        token = rmsStorage.getToken();
        userId = rmsStorage.getLogin();
        ActionData contentActionData = getContentAction.getMainData();
        Attributes inAttr = contentActionData.getAttributes();
        videoId = inAttr.get("content:id");
        if (token == null || token.trim().length() <= 0) {
            result = 5;
        } else if (videoId == null) {
            result = 4;
        } else if (videoId.trim().length() <= 0) {
            result = 2;
        } else {
            try {
                url = "http://gdata.youtube.com/feeds/api/users/" + userId + "/uploads/" + videoId;
                parser = new GetVideoInfoParser();
                request = new YouTubeRequest("GET", parser, url, AuthenticationUtils.createHeaders(token));
                ActionUtil.doHttpRequest(request);
                result = ActionUtil.resultFromHttpResponseCode(request.getResponseCode());
            }
            catch (ServiceException se) {
                Log.error("ServiceException catch during Get video info request: " + se.getMessage());
            }
            if (result == 0) {
                content.setTitle(parser.getTitle());
                content.setDescription(parser.getDescription());
                content.setKeywords(parser.getKeywords());
                content.setId(videoId);
                if (parser.getCategory() != null) {
                    content.setCategory(parser.getCategory());
                }
                if (parser.getGeoRss() != null) {
                    content.setGeoRss(parser.getGeoRss());
                }
                if (parser.getLocation() != null) {
                    content.setLocation(parser.getLocation());
                }
                if (parser.getNoEmbed() != null) {
                    content.setNoEmbed(parser.getNoEmbed());
                }
                if (parser.getAccess() != null) {
                    content.setAccess("private");
                }
                outAttr = EntryCodec.encodeEntry(content);
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        contentActionData.setAttributes(outAttr);
    }
}

