/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.action;

import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.EntryList;
import com.sonyericsson.webalbum.model.ImageResource;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.MimeUtil;
import com.sonyericsson.youtube.model.YouTubeContent;
import com.sonyericsson.youtube.service.action.ActionUtil;
import com.sonyericsson.youtube.service.http.AuthenticationUtils;
import com.sonyericsson.youtube.service.http.ListVideoRequest;
import com.sonyericsson.youtube.service.xml.ListVideoParser;
import com.sonyericsson.youtube.utils.RMSStorage;

public class ListActionHandler
implements ActionHandler {
    private RMSStorage rmsStorage;
    private String accessPointId = null;

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 12;
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        String type = inAttr.get("item:type");
        Attributes outAttr = new Attributes();
        outAttr.set("item:type", type);
        try {
            this.rmsStorage = RMSStorage.getRMSStorage();
            this.accessPointId = inAttr.get("access-point-id");
            if (type == null) {
                throw new ServiceException(4);
            }
            if (!type.equalsIgnoreCase("content")) {
                throw new ServiceException(3);
            }
            this.handleListContentRequest(action);
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing List action handler: " + se.getMessage());
            result = se.getResult();
            outAttr.set("result", Result.toString(result), 0);
            actionData.setAttributes(outAttr);
        }
        responseListener.actionCompleteNotify(action);
    }

    private void handleListContentRequest(Action listContentAction) {
        ActionData listContentActionData;
        Attributes outAttr;
        int result;
        block12: {
            result = 0;
            int startIndex = 0;
            int endIndex = Integer.MAX_VALUE;
            EntryList contentList = null;
            outAttr = new Attributes();
            Attributes partOutAttr = null;
            listContentActionData = listContentAction.getMainData();
            Attributes inAttr = listContentActionData.getAttributes();
            String isRefreshForced = inAttr.get("list:force-refresh");
            String startIndexStr = inAttr.get("list:start-entry");
            String endIndexStr = inAttr.get("list:end-entry");
            String authToken = this.rmsStorage.getToken();
            try {
                if (authToken == null) {
                    throw new ServiceException(5);
                }
                if (isRefreshForced == null) {
                    throw new ServiceException(4);
                }
                if (!isRefreshForced.equalsIgnoreCase("true") && !isRefreshForced.equalsIgnoreCase("false")) {
                    throw new ServiceException(2);
                }
                if (startIndexStr != null && endIndexStr != null) {
                    try {
                        startIndex = Integer.parseInt(startIndexStr);
                        endIndex = Integer.parseInt(endIndexStr);
                    }
                    catch (NumberFormatException nfEx) {
                        Log.error("Error trying to parse startIndex and EndIndex: " + nfEx.getMessage());
                        throw new ServiceException(2);
                    }
                }
                if (endIndex <= startIndex) {
                    throw new ServiceException(2);
                }
                ListVideoParser listVideoParser = new ListVideoParser();
                this.executeRequests(startIndex, endIndex, listVideoParser, authToken, isRefreshForced);
                contentList = listVideoParser.getEntries();
                if (contentList != null) {
                    Log.trace(this, "Getting parsed entries. Number of entries: " + contentList.getTotalNrOfEntries());
                    int i = startIndex;
                    int j = 0;
                    while (i < endIndex) {
                        Entry entry = contentList.getEntry(j);
                        if (entry == null) {
                            Log.trace(this, "Returned null content. Ending content list filling loop.");
                            endIndex = i;
                            break;
                        }
                        YouTubeContent contentEntry = this.getContentImage(entry);
                        ActionData childData = listContentAction.addChildData();
                        partOutAttr = EntryCodec.encodeEntry(contentEntry);
                        childData.setAttributes(partOutAttr);
                        ++i;
                        ++j;
                    }
                    Log.trace(this, "Ended parsing content entries with result " + result + ".");
                    outAttr.set("list:entry-count", String.valueOf(contentList.getTotalNrOfEntries()));
                    outAttr.set("list:start-entry", String.valueOf(startIndex));
                    outAttr.set("list:end-entry", String.valueOf(endIndex));
                    break block12;
                }
                throw new ServiceException(12);
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException performing List Content Action Handler: " + se.getMessage());
                result = se.getResult();
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        listContentActionData.setAttributes(outAttr);
    }

    private YouTubeContent getContentImage(Entry entry) {
        YouTubeContent contentEntry = (YouTubeContent)entry;
        ImageResource thumbImg = null;
        String thumbUrl = contentEntry.getVideoThumbnail();
        if (thumbUrl != null && thumbUrl.length() > 0) {
            thumbImg = new ImageResource("thumbnail", thumbUrl, MimeUtil.getContentTypeFromUrl(thumbUrl), 75, 75);
            contentEntry.addResource(thumbImg);
        }
        return contentEntry;
    }

    private void executeRequests(int startIndex, int endIndex, ListVideoParser listVideoParser, String token, String isRefreshForced) throws ServiceException {
        int localStartIndex = startIndex;
        int localEndIndex = endIndex;
        int maxResults = 0;
        int finalResults = 0;
        String fullRequestUrl = "";
        maxResults = finalResults = localEndIndex - localStartIndex;
        if (finalResults > 50) {
            maxResults = 50;
        }
        ++localStartIndex;
        do {
            fullRequestUrl = "http://gdata.youtube.com/feeds/api/users/default/uploads".concat("?").concat("start-index").concat("=").concat(String.valueOf(localStartIndex)).concat("&").concat("max-results").concat("=").concat(String.valueOf(maxResults));
            fullRequestUrl = ActionUtil.getAPIdUrl(this.accessPointId, fullRequestUrl);
            listVideoParser.setHasNext(false);
            ListVideoRequest listContentReq = new ListVideoRequest(fullRequestUrl, AuthenticationUtils.createHeaders(token), listVideoParser);
            ActionUtil.doHttpRequest(listContentReq, isRefreshForced.equalsIgnoreCase("true"));
            localStartIndex += 50;
            maxResults = finalResults - listVideoParser.getNumberOfVideos() >= 50 ? 50 : finalResults - listVideoParser.getNumberOfVideos();
        } while (listVideoParser.hasNext() && listVideoParser.getNumberOfVideos() != finalResults);
    }
}

