/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.action;

import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.http.HttpUtil;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.youtube.service.action.ActionUtil;
import com.sonyericsson.youtube.service.http.RemoveRequest;
import com.sonyericsson.youtube.utils.RMSStorage;
import java.io.IOException;

public class RemoveActionHandler
implements ActionHandler {
    private RMSStorage rmsStorage;

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 12;
        Log.info("Starting handleAction");
        ActionData actionData = action.getMainData();
        Attributes outAttr = new Attributes();
        Attributes inAttr = actionData.getAttributes();
        String type = inAttr.get("item:type");
        String contentId = inAttr.get("content:id");
        String token = null;
        try {
            this.rmsStorage = RMSStorage.getRMSStorage();
            token = this.rmsStorage.getToken();
            if (type == null || contentId == null) {
                throw new ServiceException(4);
            }
            if (!type.equalsIgnoreCase("content") || contentId.length() <= 0) {
                throw new ServiceException(2);
            }
            if (token == null || token.length() <= 0) {
                throw new ServiceException(5);
            }
            Log.info("Creating request");
            RemoveRequest removeReq = new RemoveRequest(token, contentId);
            HttpUtil.doRequest(removeReq);
            int httpResponse = removeReq.getResponseCode();
            Log.info("HTTP response code: " + httpResponse);
            result = ActionUtil.resultFromHttpResponseCode(httpResponse);
        }
        catch (ServiceException se) {
            result = se.getResult();
        }
        catch (IOException ioe) {
            result = 8;
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

