/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.action;

import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.youtube.model.YouTubeContent;
import com.sonyericsson.youtube.service.action.ActionUtil;
import com.sonyericsson.youtube.service.http.AuthenticationUtils;
import com.sonyericsson.youtube.service.http.UpdateContentRequest;
import com.sonyericsson.youtube.service.http.YouTubeRequest;
import com.sonyericsson.youtube.service.xml.GetVideoInfoParser;
import com.sonyericsson.youtube.utils.RMSStorage;

public class UpdateActionHandler
implements ActionHandler {
    private static final String EDIT_CONTENT_UPLOADS = "/uploads/";

    public void handleAction(Action action, ActionResponseListener responseListener) {
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Attributes outAttr = new Attributes();
        String type = inAttr.get("item:type");
        if (type == null) {
            outAttr.set("result", Result.toString(4), 0);
            actionData.setAttributes(outAttr);
        } else if (type.equalsIgnoreCase("content")) {
            this.handleUpdateContentRequest(action);
        } else {
            outAttr.set("result", Result.toString(3), 0);
            actionData.setAttributes(outAttr);
        }
        responseListener.actionCompleteNotify(action);
    }

    private void handleUpdateContentRequest(Action updateContentAction) {
        int result = 12;
        YouTubeContent originalContent = new YouTubeContent();
        YouTubeContent updatedContent = new YouTubeContent();
        ActionData mainData = updateContentAction.getMainData();
        Attributes inAttr = mainData.getAttributes();
        Attributes outAttr = new Attributes();
        RMSStorage rmsStorage = null;
        String token = null;
        String userId = null;
        String url = null;
        try {
            rmsStorage = RMSStorage.getRMSStorage();
        }
        catch (ServiceException se) {
            Log.error(this, "ServiceException performing get action handler: " + se.getMessage());
            result = se.getResult();
            outAttr.set("result", Result.toString(result), 0);
        }
        token = rmsStorage.getToken();
        updatedContent.setAccess(inAttr.get("content:access"));
        updatedContent.setDescription(inAttr.get("content:description"));
        updatedContent.setKeywords(inAttr.get("content:keywords"));
        updatedContent.setTitle(inAttr.get("content:title"));
        userId = rmsStorage.getLogin();
        String videoId = inAttr.get("content:id");
        try {
            if (videoId == null) {
                Log.error("VideoId in Update Action Handler is null");
                throw new ServiceException(4);
            }
            if (videoId.trim().length() <= 0) {
                Log.error("Error retrieving videoId in Update Action Handler");
                throw new ServiceException(2);
            }
            if (userId != null && userId.trim().length() <= 0) {
                Log.error("Error retrieving userId in Update Action Handler");
                throw new ServiceException(5);
            }
            url = "http://gdata.youtube.com/feeds/api/users/" + userId + EDIT_CONTENT_UPLOADS + videoId;
            GetVideoInfoParser getVideoInfoParser = new GetVideoInfoParser();
            YouTubeRequest youTubeRequest = new YouTubeRequest("GET", getVideoInfoParser, url, AuthenticationUtils.createHeaders(token));
            ActionUtil.doHttpRequest(youTubeRequest);
            result = ActionUtil.resultFromHttpResponseCode(youTubeRequest.getResponseCode());
            originalContent = getVideoInfoParser.getContent();
        }
        catch (ServiceException se) {
            Log.error("ServiceException in Update Action Handler: " + se.getMessage());
            result = se.getResult();
        }
        if (originalContent != null && result == 0) {
            originalContent.setId(videoId);
            updatedContent.setId(videoId);
            UpdateContentRequest editContReq = new UpdateContentRequest(originalContent, updatedContent, AuthenticationUtils.createHeaders(token));
            result = editContReq.doRequest();
        } else if (originalContent == null && result == 0) {
            Log.error("Error in Update Action Handler: content is null");
            result = 9;
        }
        outAttr.set("result", Result.toString(result), 0);
        mainData.setAttributes(outAttr);
    }
}

