/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.action;

import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.job.JobManager;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.UploadItem;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.TransferJobResponseHandler;
import com.sonyericsson.youtube.service.action.UploadJob;
import com.sonyericsson.youtube.utils.RMSStorage;
import java.util.Hashtable;

public class UploadActionHandler
implements ActionHandler,
ActionResponseListener {
    private JobManager jobManager;
    private ActionResponseListener mainResponseListener;
    private Hashtable uploadJobHash = new Hashtable();
    private RMSStorage rmsStorage;

    public UploadActionHandler(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        this.mainResponseListener = responseListener;
        ActionData mainData = action.getMainData();
        Attributes mainInAttr = mainData.getAttributes();
        String baseDir = mainData.getUrl();
        String accessPointId = null;
        String token = null;
        int transferId = -1;
        try {
            this.rmsStorage = RMSStorage.getRMSStorage();
            token = this.rmsStorage.getToken();
            int count = action.getChildDataCount();
            UploadItem[] items = new UploadItem[count];
            if (baseDir == null) {
                throw new ServiceException(4);
            }
            try {
                transferId = Integer.parseInt(mainInAttr.get("transfer:id"));
                if (-1 == transferId) {
                    throw new ServiceException(2);
                }
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException(2);
            }
            accessPointId = mainInAttr.get("access-point-id");
            if (token == null || token.trim().length() == 0) {
                throw new ServiceException(5);
            }
            int i = 0;
            while (i < count) {
                ActionData childData = action.getChildData(i);
                Entry entry = EntryCodec.decodeEntry(childData.getAttributes());
                String localUrl = childData.getUrl();
                items[i] = new UploadItem(entry);
                if (entry instanceof Content && localUrl != null) {
                    Resource resource = new Resource("content");
                    resource.setLocalUrl(localUrl);
                    entry.addResource(resource);
                    items[i].setState(1);
                } else {
                    items[i].setState(4);
                }
                ++i;
            }
            UploadJob uj = new UploadJob(transferId, items, token, accessPointId);
            uj.setTransferJobListener(new TransferJobResponseHandler(action, this));
            this.uploadJobHash.put(new Integer(transferId), uj);
            this.jobManager.addJob(uj);
        }
        catch (ServiceException se) {
            int result = se.getResult();
            Attributes outAttr = new Attributes();
            outAttr.set("result", Result.toString(result), 0);
            mainData.setAttributes(outAttr);
            this.mainResponseListener.actionCompleteNotify(action);
        }
    }

    public void actionCompleteNotify(Action action) {
        this.mainResponseListener.actionCompleteNotify(action);
    }

    public void actionProgressNotify(Action action) {
        this.mainResponseListener.actionProgressNotify(action);
    }
}

