/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.action;

import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.UploadItem;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.TransferJob;
import com.sonyericsson.webalbum.service.transfer.TransferRequestProgressListener;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.util.MimeUtil;
import com.sonyericsson.youtube.service.http.UploadContentRequest;
import com.sonyericsson.youtube.service.xml.UploadLinkParser;
import java.util.Vector;

public class UploadJob
extends TransferJob
implements TransferRequestProgressListener {
    private static final int UPLOAD_PROGRESS_INTERVAL = 10240;
    private String token;
    private String accessPointId;
    private Vector uploadedVideoIdVector = new Vector();

    protected UploadJob(int id, UploadItem[] items, String token, String apId) {
        super(id, items);
        this.token = token;
        this.accessPointId = apId;
    }

    protected int transferCurrentItem() {
        UploadItem item = (UploadItem)this.getCurrentItem();
        Entry entry = item.getEntry();
        item.setState(2);
        return this.uploadContent((Content)entry);
    }

    private int uploadContent(Content content) {
        int result;
        block19: {
            result = 12;
            UploadItem item = (UploadItem)this.getCurrentItem();
            int fileSize = 0;
            try {
                try {
                    Log.trace("UploadJob#uploadContent: Starting upload");
                    Resource resource = content.getResource("content");
                    if (resource == null) {
                        throw new ServiceException(2);
                    }
                    String localUrl = resource.getLocalUrl();
                    if (localUrl == null) {
                        throw new ServiceException(4);
                    }
                    if (localUrl.length() <= 0) {
                        throw new ServiceException(2);
                    }
                    String title = content.getTitle();
                    String description = content.getDescription();
                    String access = content.getAccess();
                    String keyWords = content.getKeywords();
                    if (title == null || description == null || access == null || keyWords == null) {
                        throw new ServiceException(4);
                    }
                    if (title.length() <= 0 || description.length() <= 0 || access.length() <= 0 || keyWords.length() <= 0) {
                        throw new ServiceException(2);
                    }
                    String contentType = this.getContentType(localUrl);
                    fileSize = IOUtil.getFileSize(localUrl);
                    item.setTotalNrBytes(fileSize);
                    UploadLinkParser upParser = new UploadLinkParser();
                    this.currentRequest = new UploadContentRequest(upParser, content, this.token, contentType, this.accessPointId);
                    this.currentRequest.setTransferRequestProgressListener(this, 10240);
                    if (this.cancelled) {
                        this.currentRequest.cancel();
                        break block19;
                    }
                    result = ((UploadContentRequest)this.currentRequest).doRequest();
                }
                catch (ServiceException e) {
                    Log.logException(e);
                    result = e.getResult();
                    if (!this.cancelled && result == 0) {
                        item.setCurrentNrBytes(fileSize);
                        item.setState(5);
                    } else if (this.cancelled || this.currentRequest != null && this.currentRequest.isCancelled()) {
                        item.setState(3);
                        result = 1;
                    } else {
                        item.setState(4);
                    }
                    this.currentRequest = null;
                }
            }
            finally {
                if (!this.cancelled && result == 0) {
                    item.setCurrentNrBytes(fileSize);
                    item.setState(5);
                } else if (this.cancelled || this.currentRequest != null && this.currentRequest.isCancelled()) {
                    item.setState(3);
                    result = 1;
                } else {
                    item.setState(4);
                }
                this.currentRequest = null;
            }
        }
        return result;
    }

    private String getContentType(String localUrl) {
        int lastDotPos;
        String contentType = MimeUtil.getContentTypeFromUrl(localUrl);
        if (contentType == "" && (lastDotPos = localUrl.lastIndexOf(46)) >= 0) {
            if (localUrl.substring(lastDotPos).equalsIgnoreCase(".mp4")) {
                contentType = "video/mp4";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".3gp")) {
                contentType = "video/3gpp";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".wmv")) {
                contentType = "video/x-ms-wmv";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".avi")) {
                contentType = "video/avi";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".mov")) {
                contentType = "video/quicktime";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".flv")) {
                contentType = "video/x-flv";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".swf")) {
                contentType = "application/x-shockwave-flash";
            } else if (localUrl.substring(lastDotPos).equalsIgnoreCase(".mkv")) {
                contentType = "video/x-matroska";
            }
        }
        return contentType;
    }

    public Vector getUploadedVideoIdVector() {
        return this.uploadedVideoIdVector;
    }
}

