/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.http;

import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.xml.XmlEncoder;
import com.sonyericsson.youtube.model.YouTubeContent;
import com.sonyericsson.youtube.service.action.ActionUtil;
import com.sonyericsson.youtube.utils.RMSStorage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class UpdateContentRequest {
    private final String EDIT_CONTENT_METHOD;
    private final String EDIT_CONTENT_UPLOADS;
    private final String CATEGORY_PEOPLE;
    private static RMSStorage rmsStorage;
    private String access = null;
    private String category = null;
    private String description = null;
    private String geoRss = null;
    private String keywords = null;
    private String location = null;
    private String noEmbed = null;
    private String title = null;
    private String token = null;
    private String userId = null;
    private String videoId = null;
    private String editRequestUrl = null;
    YouTubeContent originalContent = null;
    YouTubeContent updatedContent = null;

    public UpdateContentRequest(YouTubeContent originalContent, YouTubeContent updatedContent, Hashtable headers) {
        this.EDIT_CONTENT_METHOD = "http://gdata.youtube.com/feeds/api/users/";
        this.EDIT_CONTENT_UPLOADS = "/uploads/";
        this.CATEGORY_PEOPLE = "People";
        this.originalContent = originalContent;
        this.updatedContent = updatedContent;
    }

    public int doRequest() {
        int result;
        HttpConnection conn;
        block18: {
            OutputStream os = null;
            conn = null;
            XmlEncoder enc = null;
            int xmlAtomEntryLength = 0;
            result = 12;
            try {
                this.editRequestUrl = this.getAttributes(this.originalContent, this.updatedContent);
                enc = this.createAtomEntry();
                xmlAtomEntryLength = enc.getDataLength();
                conn = (HttpConnection)Connector.open((String)this.editRequestUrl);
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("Host", "gdata.youtube.com");
                conn.setRequestProperty("Content-Type", "application/atom+xml");
                conn.setRequestProperty("Content-Length", String.valueOf(xmlAtomEntryLength));
                conn.setRequestProperty("Authorization", "GoogleLogin auth=" + this.token);
                conn.setRequestProperty("GData-Version", "2");
                conn.setRequestProperty("X-GData-Key", "key=AI39si4ROmiAVzNlNn2mOZKjf_uW0Y6Gwy0LF3ZfMSGyNbzawUZ451JwaHOhr6VKBHgJ6ifbqUlJK4nmApiohLeE4jsOXNv5Hw");
            }
            catch (IOException connIoe) {
                Log.error(this, "IOException opening connection to Youtube: " + connIoe.getMessage());
                result = 8;
            }
            catch (ServiceException se) {
                Log.error(this, "ServiceException getting video update parameters: " + se.getMessage());
                result = se.getResult();
            }
            if (result != 8) {
                try {
                    try {
                        os = conn.openOutputStream();
                        enc.setOutputStream(os);
                        enc.flush();
                        os.flush();
                    }
                    catch (IOException ioe) {
                        Log.error(this, "IOException editing file: " + ioe.getMessage());
                        result = 8;
                        try {
                            os.close();
                        }
                        catch (IOException ioe2) {
                            Log.error(this, "IOException closing streams: " + ioe2.getMessage());
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        os.close();
                    }
                    catch (IOException ioe) {
                        Log.error(this, "IOException closing streams: " + ioe.getMessage());
                    }
                    throw throwable;
                }
                try {
                    os.close();
                }
                catch (IOException ioe) {
                    Log.error(this, "IOException closing streams: " + ioe.getMessage());
                }
            }
        }
        if (result != 8) {
            try {
                Log.trace("HTTP response: " + conn.getResponseCode());
                result = ActionUtil.resultFromHttpResponseCode(conn.getResponseCode());
            }
            catch (IOException ioe) {
                Log.error(this, "IOException receiving response: " + ioe.getMessage());
                result = 8;
            }
        }
        return result;
    }

    private String getAttributes(YouTubeContent originalContent, YouTubeContent updatedContent) throws ServiceException {
        this.access = updatedContent.getAccess();
        this.description = updatedContent.getDescription();
        this.keywords = updatedContent.getKeywords();
        this.title = updatedContent.getTitle();
        if (this.access == null || this.access.trim().length() <= 0) {
            this.access = originalContent.getAccess();
        }
        if (this.description == null || this.description.trim().length() <= 0) {
            this.description = originalContent.getDescription();
        }
        if (this.keywords == null || this.keywords.trim().length() <= 0) {
            this.keywords = originalContent.getKeywords();
        }
        if (this.title == null || this.title.trim().length() <= 0) {
            this.title = originalContent.getTitle();
        }
        this.category = originalContent.getCategory();
        if (this.category == null || this.title.trim().length() <= 0) {
            this.category = "People";
        }
        this.geoRss = originalContent.getGeoRss();
        this.location = originalContent.getLocation();
        this.noEmbed = originalContent.getNoEmbed();
        this.videoId = originalContent.getId();
        rmsStorage = RMSStorage.getRMSStorage();
        this.token = rmsStorage.getToken();
        this.userId = rmsStorage.getLogin();
        if (this.access == null) {
            this.access = "public";
        }
        if (this.token == null || this.token.trim().length() <= 0) {
            Log.error("Invalid autorization parameters");
            throw new ServiceException(5);
        }
        if (this.description == null || this.keywords == null || this.title == null || this.videoId == null || this.userId == null) {
            throw new ServiceException(4);
        }
        if (this.description.trim().length() <= 0 || this.keywords.trim().length() <= 0 || this.title.trim().length() <= 0 || this.videoId.trim().length() <= 0 || this.userId.trim().length() <= 0) {
            throw new ServiceException(2);
        }
        return "http://gdata.youtube.com/feeds/api/users/" + this.userId + "/uploads/" + this.videoId;
    }

    private XmlEncoder createAtomEntry() throws IOException {
        XmlEncoder enc = new XmlEncoder();
        enc.startElement("entry", "xmlns=\"http://www.w3.org/2005/Atom\" xmlns:media=\"http://search.yahoo.com/mrss/\" xmlns:yt=\"http://gdata.youtube.com/schemas/2007\"");
        enc.startElement("media:group");
        enc.addElement("media:title", "type=\"plain\"", this.title);
        enc.addElement("media:description", "type=\"plain\"", this.description);
        enc.addElement("media:category", "scheme=\"http://gdata.youtube.com/schemas/2007/categories.cat\"", this.category);
        enc.addElement("media:keywords", null, this.keywords);
        if (this.access != null && this.access.equalsIgnoreCase("private")) {
            enc.addElement("yt:private", null);
        }
        enc.endElement();
        if (this.location != null && this.location.trim().length() > 0) {
            enc.addElement("yt:location", null, this.location);
        }
        if (this.noEmbed != null && this.noEmbed.equalsIgnoreCase("yt:noembed")) {
            enc.addElement("yt:noEmbed", null);
        }
        if (this.geoRss != null && this.geoRss.equalsIgnoreCase("georss:where")) {
            enc.addElement("georss:where", null);
        }
        enc.endElement();
        return enc;
    }
}

