/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.http;

import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.TransferRequest;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.xml.XmlEncoder;
import com.sonyericsson.youtube.service.action.ActionUtil;
import com.sonyericsson.youtube.service.xml.UploadLinkParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;

public class UploadContentRequest
extends TransferRequest {
    private String token = null;
    private String title = null;
    private String description = null;
    private String access = null;
    private String keyWords = null;
    private String fileUrl = null;
    private String videoFileName = null;
    private String uploadFileUrl = null;
    private String accessPointId = null;
    private static final String BOUNDARY = "f93dcbA3";
    StringBuffer bodyPartSb1 = new StringBuffer();
    StringBuffer bodyPartSb2 = new StringBuffer();
    StringBuffer closingPartSb = new StringBuffer();

    public UploadContentRequest(UploadLinkParser parser, Content content, String token, String contentType, String accessPointId) {
        super("POST", "http://uploads.gdata.youtube.com/feeds/api/users/default/uploads", new Hashtable(), 1024);
        this.token = token;
        this.accessPointId = accessPointId;
        if (content == null) {
            Log.error(this, "Invalid parameters passed in request constructor");
            throw new IllegalArgumentException("Invalid parameters passed in request constructor");
        }
        Resource resource = content.getResource("content");
        this.uploadFileUrl = resource.getLocalUrl();
        this.videoFileName = this.uploadFileUrl.substring(this.uploadFileUrl.lastIndexOf(47) + 1);
        this.title = content.getTitle();
        this.description = content.getDescription();
        this.access = content.getAccess();
        this.keyWords = content.getKeywords();
        if (parser == null || token == null || token.length() <= 0 || contentType == null || contentType.length() <= 0) {
            Log.error(this, "Invalid parameters passed in request constructor");
            throw new IllegalArgumentException("Invalid parameters passed in request constructor");
        }
        this.fileUrl = this.uploadFileUrl;
        this.bodyPartSb1.append("--f93dcbA3").append("\r\n");
        this.bodyPartSb1.append("Content-Type: application/atom+xml; charset=UTF-8").append("\r\n").append("\r\n");
        this.bodyPartSb2.append("\r\n").append("--f93dcbA3").append("\r\n");
        this.bodyPartSb2.append("Content-Type: " + contentType).append("\r\n");
        this.bodyPartSb2.append("Content-Transfer-Encoding: binary").append("\r\n").append("\r\n");
        this.closingPartSb.append("\r\n").append("--f93dcbA3--").append("\r\n");
    }

    /*
     * Loose catch block
     */
    public int doRequest() {
        int result;
        block23: {
            result = 12;
            XmlEncoder enc = null;
            HttpConnection conn = null;
            OutputStream os = null;
            FileConnection fc = null;
            InputStream videoIs = null;
            int xmlAtomEntryLength = 0;
            long bytesToRead = 0L;
            try {
                try {
                    fc = (FileConnection)Connector.open((String)this.fileUrl, (int)1);
                    videoIs = fc.openInputStream();
                    bytesToRead = fc.fileSize();
                    enc = this.createAtomEntry();
                    xmlAtomEntryLength = enc.getDataLength();
                }
                catch (IOException ioe) {
                    Log.error(this, "IOException accessing file to upload: " + ioe.getMessage());
                    throw new ServiceException(9);
                }
                Log.info("Create and configure the HTTP Connection");
                String requestUrl = ActionUtil.getAPIdUrl(this.accessPointId, "http://uploads.gdata.youtube.com/feeds/api/users/default/uploads");
                conn = (HttpConnection)Connector.open((String)requestUrl);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Host", "uploads.gdata.youtube.com");
                conn.setRequestProperty("Authorization", "GoogleLogin auth=" + this.token);
                conn.setRequestProperty("GData-Version", "2");
                conn.setRequestProperty("X-GData-Key", "key=AI39si4ROmiAVzNlNn2mOZKjf_uW0Y6Gwy0LF3ZfMSGyNbzawUZ451JwaHOhr6VKBHgJ6ifbqUlJK4nmApiohLeE4jsOXNv5Hw");
                conn.setRequestProperty("Slug", this.videoFileName);
                conn.setRequestProperty("Content-Type", "multipart/related; boundary=\"f93dcbA3\"");
                conn.setRequestProperty("Content-Length", String.valueOf((long)(this.bodyPartSb1.length() + this.bodyPartSb2.length() + this.closingPartSb.length()) + bytesToRead + (long)xmlAtomEntryLength));
                conn.setRequestProperty("Connection", "close");
                try {
                    try {
                        os = conn.openOutputStream();
                        os.write(this.bodyPartSb1.toString().getBytes("UTF-8"));
                        enc.setOutputStream(os);
                        enc.flush();
                        os.write(this.bodyPartSb2.toString().getBytes("UTF-8"));
                        this.copyStream(videoIs, os);
                        os.write(this.closingPartSb.toString().getBytes());
                    }
                    catch (IOException ioe) {
                        Log.error(this, "IOException uploading file: " + ioe.getMessage());
                        throw new ServiceException(8);
                    }
                }
                finally {
                    try {
                        os.flush();
                        os.close();
                    }
                    catch (IOException ioe) {
                        Log.error(this, "IOException closing streams: " + ioe.getMessage());
                        throw new ServiceException(8);
                    }
                }
                try {
                    Log.trace("HTTP response: " + conn.getResponseCode());
                    result = ActionUtil.resultFromHttpResponseCode(conn.getResponseCode());
                }
                catch (IOException ioe) {
                    Log.error(this, "IOException receiving response: " + ioe.getMessage());
                    throw new ServiceException(8);
                }
            }
            catch (ServiceException se) {
                Log.error("ServiceException uploading video to Youtube: " + se.getResult());
                result = se.getResult();
                IOUtil.closeConnection(conn);
                IOUtil.closeInputStream(videoIs);
                IOUtil.closeConnection((Connection)fc);
                break block23;
            }
            catch (IOException connIoe) {
                Log.error(this, "IOException uploading video to Youtube: " + connIoe.getMessage());
                result = 8;
                IOUtil.closeConnection(conn);
                IOUtil.closeInputStream(videoIs);
                IOUtil.closeConnection((Connection)fc);
                break block23;
            }
            catch (Exception ex) {
                Log.error(this, "Exception uploading video to Youtube: " + ex);
                result = 12;
                {
                    catch (Throwable throwable) {
                        IOUtil.closeConnection(conn);
                        IOUtil.closeInputStream(videoIs);
                        IOUtil.closeConnection((Connection)fc);
                        throw throwable;
                    }
                }
                IOUtil.closeConnection(conn);
                IOUtil.closeInputStream(videoIs);
                IOUtil.closeConnection((Connection)fc);
                break block23;
            }
            IOUtil.closeConnection((Connection)conn);
            IOUtil.closeInputStream(videoIs);
            IOUtil.closeConnection((Connection)fc);
        }
        return result;
    }

    private XmlEncoder createAtomEntry() throws IOException {
        XmlEncoder enc = new XmlEncoder();
        enc.startElement("entry", "xmlns=\"http://www.w3.org/2005/Atom\" xmlns:media=\"http://search.yahoo.com/mrss/\" xmlns:yt=\"http://gdata.youtube.com/schemas/2007\"");
        enc.startElement("media:group");
        enc.addElement("media:title", "type=\"plain\"", this.title);
        enc.addElement("media:description", "type=\"plain\"", this.description);
        enc.addElement("media:category", "scheme=\"http://gdata.youtube.com/schemas/2007/categories.cat\"", "People");
        enc.addElement("media:keywords", null, this.keyWords);
        if (this.access.equalsIgnoreCase("private")) {
            enc.addElement("yt:private", null);
        }
        enc.endElement();
        enc.endElement();
        return enc;
    }
}

