/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.http;

import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.CacheUtil;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.xml.XmlException;
import com.sonyericsson.webalbum.xml.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.file.FileConnection;

public class YouTubeRequest
extends HttpRequest {
    protected XmlParser parser;
    protected String requestUrl = "";

    public YouTubeRequest(String method, XmlParser parser, String url, Hashtable headers) {
        super(method, url, headers);
        this.requestUrl = url;
        this.parser = parser;
    }

    protected InputStream cacheResponse(InputStream is) {
        InputStream returnIs = null;
        String localUrl = null;
        localUrl = CacheUtil.getCachedFileUrl(this.requestUrl);
        if (localUrl == null) {
            Log.error(this, "Failed to create local cache.");
            returnIs = is;
        } else {
            FileConnection cacheFconn = null;
            OutputStream os = null;
            try {
                try {
                    cacheFconn = CacheUtil.createCachedFile(localUrl);
                    os = cacheFconn.openOutputStream();
                    IOUtil.copyStream(is, os);
                    os.flush();
                    os.close();
                    CacheUtil.markCachedFileAsValid(localUrl);
                    returnIs = cacheFconn.openInputStream();
                }
                catch (IOException ioe) {
                    Log.error(this, "IOException saving response to cache: " + ioe.getMessage());
                    returnIs = is;
                    try {
                        os.flush();
                        os.close();
                    }
                    catch (IOException ioe2) {
                        Log.error(this, "IOException saving response to cache: " + ioe2.getMessage());
                    }
                }
            }
            finally {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException ioe) {
                    Log.error(this, "IOException saving response to cache: " + ioe.getMessage());
                }
            }
        }
        return returnIs;
    }

    public void readResponseBody(InputStream is) throws IOException {
        if (this.getResponseCode() == 200 || this.getResponseCode() == 201) {
            this.parseResponse(is);
        }
    }

    public void parseResponse(InputStream is) throws IOException {
        try {
            this.parser.parse(is);
        }
        catch (XmlException e) {
            Log.error(this, "XmlException parsing response: " + e.getMessage());
            Log.logException(e);
        }
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }
}

